#!/bin/sh

# panic: Bad tailq NEXT(0xffffffff81cb0ba0->tqh_last) != NULL
# cpuid = 0
# time = 1605424954
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe010125c2e0
# vpanic() at vpanic+0x182/frame 0xfffffe010125c330
# panic() at panic+0x43/frame 0xfffffe010125c390
# callout_process() at callout_process+0x34f/frame 0xfffffe010125c400
# handleevents() at handleevents+0x185/frame 0xfffffe010125c440
# timercb() at timercb+0x196/frame 0xfffffe010125c490
# lapic_handle_timer() at lapic_handle_timer+0x9b/frame 0xfffffe010125c4c0
# Xtimerint() at Xtimerint+0xb1/frame 0xfffffe010125c4c0
# --- interrupt, rip = 0xffffffff80c56c69, rsp = 0xfffffe010125c590, rbp = 0xfffffe010125c5c0 ---
# witness_unlock() at witness_unlock+0x79/frame 0xfffffe010125c5c0
# __mtx_unlock_flags() at __mtx_unlock_flags+0x4d/frame 0xfffffe010125c5f0
# kqueue_register() at kqueue_register+0x9e3/frame 0xfffffe010125c680
# kqueue_kevent() at kqueue_kevent+0x106/frame 0xfffffe010125c950
# kern_kevent_fp() at kern_kevent_fp+0x95/frame 0xfffffe010125c9a0
# kern_kevent() at kern_kevent+0x80/frame 0xfffffe010125ca00
# kern_kevent_generic() at kern_kevent_generic+0x70/frame 0xfffffe010125ca60
# sys_kevent() at sys_kevent+0x61/frame 0xfffffe010125cac0
# amd64_syscall() at amd64_syscall+0x144/frame 0xfffffe010125cbf0
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe010125cbf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x800380c6a, rsp = 0x7fffffffe4d8, rbp = 0x7fffffffe500 ---
# KDB: enter: panic
# [ thread pid 36082 tid 144846 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10aa7f6(%rip)
# db> x/s version
# version:        FreeBSD 13.0-CURRENT #0 r367672: Sat Nov 14 08:42:14 CET 2020
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

# Fixed by r367849

. ../default.cfg
cat > /tmp/syzkaller27.c <<EOF
// https://syzkaller.appspot.com/bug?id=6b64d673525304a89af91e0db71f2dee8e8da0f7
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+79569cd4d76636b2cc1c@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_kqueue);
  if (res != -1)
    r[0] = res;
  *(uint64_t*)0x200000c0 = 0;
  *(uint16_t*)0x200000c8 = 0xfff9;
  *(uint16_t*)0x200000ca = 0x4001;
  *(uint32_t*)0x200000cc = 4;
  *(uint64_t*)0x200000d0 = 0;
  *(uint64_t*)0x200000d8 = 0;
  *(uint64_t*)0x200000e0 = 0;
  *(uint64_t*)0x200000e8 = 0;
  *(uint64_t*)0x200000f0 = 0;
  *(uint64_t*)0x200000f8 = 0;
  syscall(SYS_kevent, r[0], 0x200000c0ul, 1ul, 0ul, 0ul, 0ul);
}
int main(void)
{
  sleep(2);	/* pho */
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller27 -Wall -Wextra -O0 /tmp/syzkaller27.c ||
    exit 1

(cd ../testcases/swap; ./swap -t 1m -i 20 -h > /dev/null 2>&1) &
for i in `jot 256`; do
	(cd /tmp; timeout 3m ./syzkaller27) &
done
wait

rm -rf /tmp/syzkaller27 /tmp/syzkaller27.c /tmp/syzkaller.*
exit 0
