/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInitializerTypeMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkInitializerOf", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirVariable;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInitializerTypeMismatchChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInitializerTypeMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInitializerTypeMismatchChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class FirInitializerTypeMismatchChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInitializerTypeMismatchChecker INSTANCE = new FirInitializerTypeMismatchChecker();

    private FirInitializerTypeMismatchChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            KtSourceElement ktSourceElement = declaration.getReturnTypeRef().getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
                this.checkInitializerOf(context2, reporter, declaration);
            }
            FirBackingField firBackingField = declaration.getBackingField();
            if (firBackingField == null) break block1;
            FirBackingField it = firBackingField;
            boolean bl = false;
            INSTANCE.checkInitializerOf(context2, reporter, it);
        }
    }

    private final void checkInitializerOf(CheckerContext context2, DiagnosticReporter reporter, FirVariable variable) {
        FirExpression firExpression;
        block7: {
            block6: {
                FirExpression firExpression2;
                firExpression = variable.getInitializer();
                if (firExpression == null) break block6;
                FirExpression it = firExpression2 = firExpression;
                boolean bl = false;
                firExpression = !(it instanceof FirErrorExpression) ? firExpression2 : null;
                if (firExpression != null) break block7;
            }
            return;
        }
        FirExpression initializer2 = firExpression;
        KtSourceElement ktSourceElement = variable.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            return;
        }
        if (initializer2 instanceof FirComponentCall) {
            return;
        }
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(variable.getReturnTypeRef());
        FirHelpersKt.checkTypeMismatch(context2, reporter, propertyType, null, initializer2, source, true);
    }
}

