/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ=\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0018J=\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\u00020\u0017*\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "checkPsiOrLightTree", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkVisibilityModifier", "state", "Lorg/jetbrains/kotlin/config/ExplicitApiMode;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/config/ExplicitApiMode;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;)V", "explicitVisibilityIsNotRequired", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Z", "checkExplicitReturnType", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/config/ExplicitApiMode;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;)V", "returnTypeCheckIsApplicable", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExplicitApiDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n29#2:162\n38#2:166\n49#3:163\n23#3:164\n70#3:165\n1#4:167\n*S KotlinDebug\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n*L\n59#1:162\n126#1:166\n62#1:163\n63#1:164\n120#1:165\n*E\n"})
public final class FirExplicitApiDeclarationChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final FirExplicitApiDeclarationChecker INSTANCE = new FirExplicitApiDeclarationChecker();

    private FirExplicitApiDeclarationChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration element, @NotNull KtSourceElement source) {
        EffectiveVisibility containerEffectiveVisibility;
        EffectiveVisibility effectiveVisibility;
        boolean $i$f$getEffectiveVisibility;
        FirBasedSymbol $this$effectiveVisibility$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean sourceKindIsReal = source.getKind() instanceof KtRealSourceElementKind;
        if (!sourceKindIsReal && !Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) || Intrinsics.areEqual((Object)element.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE) || !(element instanceof FirMemberDeclaration)) {
            return;
        }
        ExplicitApiMode explicitApiState = FirExplicitApiDeclarationChecker.checkPsiOrLightTree$extractState(context2, (AnalysisFlag<? extends ExplicitApiMode>)AnalysisFlags.getExplicitApiMode());
        ExplicitApiMode explicitReturnTypesState = FirExplicitApiDeclarationChecker.checkPsiOrLightTree$extractState(context2, (AnalysisFlag<? extends ExplicitApiMode>)AnalysisFlags.getExplicitReturnTypes());
        if (explicitApiState == null && explicitReturnTypesState == null) {
            return;
        }
        if (element instanceof FirEnumEntry) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv2 = (FirMemberDeclaration)element;
        boolean $i$f$getEffectiveVisibility2 = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv2.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (!firResolvedDeclarationStatus.getPublicApi() && PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility(element) == null) {
            return;
        }
        FirBasedSymbol lastContainingDeclaration = (FirBasedSymbol)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (lastContainingDeclaration instanceof FirClassSymbol) {
            $this$effectiveVisibility$iv = (FirClassLikeSymbol)lastContainingDeclaration;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else if (lastContainingDeclaration instanceof FirCallableSymbol) {
            $this$effectiveVisibility$iv = (FirCallableSymbol)lastContainingDeclaration;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility = null;
        }
        EffectiveVisibility effectiveVisibility2 = containerEffectiveVisibility = effectiveVisibility;
        boolean bl = effectiveVisibility2 != null ? !effectiveVisibility2.getPublicApi() : false;
        if (bl) {
            return;
        }
        if (explicitApiState != null) {
            this.checkVisibilityModifier(context2, reporter, explicitApiState, (FirMemberDeclaration)element, source);
        }
        if (sourceKindIsReal && element instanceof FirCallableDeclaration) {
            ExplicitApiMode explicitApiMode = explicitApiState;
            if (explicitApiMode == null) {
                ExplicitApiMode explicitApiMode2 = explicitReturnTypesState;
                explicitApiMode = explicitApiMode2;
                Intrinsics.checkNotNull((Object)explicitApiMode2);
            }
            this.checkExplicitReturnType(context2, reporter, explicitApiMode, (FirCallableDeclaration)element, source);
        }
    }

    private final void checkVisibilityModifier(CheckerContext context2, DiagnosticReporter reporter, ExplicitApiMode state, FirMemberDeclaration declaration, KtSourceElement source) {
        KtSourceElement visibilityModifier;
        KtSourceElement ktSourceElement;
        IElementType iElementType = KtNodeTypes.MODIFIER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MODIFIER_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 != null) {
            TokenSet tokenSet = KtTokens.VISIBILITY_MODIFIERS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VISIBILITY_MODIFIERS");
            ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement2, tokenSet, 0, 0, false, 14, null);
        } else {
            ktSourceElement = visibilityModifier = null;
        }
        if (visibilityModifier != null) {
            return;
        }
        if (this.explicitVisibilityIsNotRequired(context2, declaration)) {
            return;
        }
        KtDiagnosticFactory0 factory2 = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)factory2, null, (int)8, null);
    }

    private final boolean explicitVisibilityIsNotRequired(CheckerContext context2, FirMemberDeclaration declaration) {
        boolean bl;
        FirMemberDeclaration firMemberDeclaration = declaration;
        if (firMemberDeclaration instanceof FirPrimaryConstructor || firMemberDeclaration instanceof FirPropertyAccessor || firMemberDeclaration instanceof FirValueParameter || firMemberDeclaration instanceof FirAnonymousFunction) {
            bl = true;
        } else if (firMemberDeclaration instanceof FirCallableDeclaration) {
            FirRegularClassSymbol containingClass;
            Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirRegularClassSymbol firRegularClassSymbol = containingClass = object instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null;
            if (declaration instanceof FirProperty && containingClass != null) {
                FirClassLikeSymbol $this$isData$iv = containingClass;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getRawStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
                    return true;
                }
            }
            FirMemberDeclaration $this$isOverride$iv = declaration;
            boolean $i$f$isOverride = false;
            bl = $this$isOverride$iv.getStatus().isOverride() || DeclarationUtilsKt.isLocalMember(declaration);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkExplicitReturnType(CheckerContext context2, DiagnosticReporter reporter, ExplicitApiMode state, FirCallableDeclaration declaration, KtSourceElement source) {
        if (!this.returnTypeCheckIsApplicable(declaration)) {
            return;
        }
        KtDiagnosticFactory0 factory2 = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)factory2, null, (int)8, null);
    }

    private final boolean returnTypeCheckIsApplicable(FirCallableDeclaration $this$returnTypeCheckIsApplicable) {
        KtSourceElement ktSourceElement = $this$returnTypeCheckIsApplicable.getReturnTypeRef().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return false;
        }
        return $this$returnTypeCheckIsApplicable instanceof FirProperty || $this$returnTypeCheckIsApplicable instanceof FirFunction && !($this$returnTypeCheckIsApplicable instanceof FirPropertyAccessor) && ((FirFunction)$this$returnTypeCheckIsApplicable).getBody() instanceof FirSingleExpressionBlock;
    }

    private static final ExplicitApiMode checkPsiOrLightTree$extractState(CheckerContext $context, AnalysisFlag<? extends ExplicitApiMode> flag) {
        Object object = $context.getLanguageVersionSettings().getFlag(flag);
        ExplicitApiMode it = (ExplicitApiMode)object;
        boolean bl = false;
        return (ExplicitApiMode)(!(it == ExplicitApiMode.DISABLED) ? object : null);
    }
}

