/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.RemoveCurlyBracesFromTemplateInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0002H\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\r\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveCurlyBracesFromTemplateInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;", "reportWithoutWhitespace", "", "<init>", "(Z)V", "inspectionText", "", "element", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "isApplicable", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.code-insight.inspections.shared"})
public final class RemoveCurlyBracesFromTemplateInspection
extends AbstractApplicabilityBasedInspection<KtBlockStringTemplateEntry> {
    @JvmField
    public boolean reportWithoutWhitespace;

    public RemoveCurlyBracesFromTemplateInspection(boolean reportWithoutWhitespace) {
        super(KtBlockStringTemplateEntry.class);
        this.reportWithoutWhitespace = reportWithoutWhitespace;
    }

    public /* synthetic */ RemoveCurlyBracesFromTemplateInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBlockStringTemplateEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"redundant.curly.braces.in.string.template", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtBlockStringTemplateEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.reportWithoutWhitespace || RemoveCurlyBracesFromTemplateInspectionKt.access$hasWhitespaceAround(element) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"remove.curly.braces", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtBlockStringTemplateEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinPsiModificationUtils.canDropCurlyBrackets(element);
    }

    @Override
    public void applyTo(@NotNull KtBlockStringTemplateEntry element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinPsiModificationUtils.dropCurlyBracketsIfPossible(element);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"reportWithoutWhitespace", (String)KotlinBundle.message((String)"report.also.for.a.variables.without.a.whitespace.around", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public RemoveCurlyBracesFromTemplateInspection() {
        this(false, 1, null);
    }
}

