/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k1.configuration;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.UiUtils;
import org.jetbrains.kotlin.idea.core.script.k1.settings.KotlinScriptingSettingsImpl;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/MultipleScriptDefinitionsChecker;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGradleDefinition", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "createNotification", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "defs", "", "kotlin.base.scripting.k1"})
@SourceDebugExtension(value={"SMAP\nMultipleScriptDefinitionsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleScriptDefinitionsChecker.kt\norg/jetbrains/kotlin/idea/core/script/k1/configuration/MultipleScriptDefinitionsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1#2:85\n30#3,2:86\n1740#4,3:88\n*S KotlinDebug\n*F\n+ 1 MultipleScriptDefinitionsChecker.kt\norg/jetbrains/kotlin/idea/core/script/k1/configuration/MultipleScriptDefinitionsChecker\n*L\n38#1:86,2\n42#1:88,3\n*E\n"})
public final class MultipleScriptDefinitionsChecker
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        List applicableDefinitions;
        block18: {
            block17: {
                boolean bl;
                block14: {
                    Object object;
                    block16: {
                        block15: {
                            KtFile ktFile2;
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            if (!FileUtils.isKotlinFileType(file)) {
                                return null;
                            }
                            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                            object = psiFile instanceof KtFile ? (KtFile)psiFile : null;
                            if (object == null) break block15;
                            KtFile p0 = ktFile2 = object;
                            boolean bl2 = false;
                            object = p0.isScript() ? ktFile2 : null;
                            if (object != null) break block16;
                        }
                        return null;
                    }
                    KtFile ktFile3 = object;
                    if (KotlinScriptingSettingsImpl.Companion.getInstance(project).getSuppressDefinitionsCheck()) {
                        return null;
                    }
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service = false;
                    Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
                    Object object2 = $this$service$iv.getService(serviceClass$iv);
                    if (object2 == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    applicableDefinitions = SequencesKt.toList((Sequence)SequencesKt.filter(((ScriptDefinitionProvider)object2).getCurrentDefinitions(), arg_0 -> MultipleScriptDefinitionsChecker.collectNotificationData$lambda$0(ktFile3, project, arg_0)));
                    if (applicableDefinitions.size() < 2) break block17;
                    Iterable $this$all$iv = applicableDefinitions;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                            boolean bl3 = false;
                            if (this.isGradleDefinition(it)) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block18;
            }
            return null;
        }
        return arg_0 -> MultipleScriptDefinitionsChecker.collectNotificationData$lambda$2(this, project, applicableDefinitions, arg_0);
    }

    private final boolean isGradleDefinition(ScriptDefinition $this$isGradleDefinition) {
        Object object = $this$isGradleDefinition instanceof ScriptDefinition.FromConfigurationsBase ? (ScriptDefinition.FromConfigurationsBase)$this$isGradleDefinition : null;
        if (object == null || (object = object.getFileNamePattern()) == null) {
            return false;
        }
        Object pattern2 = object;
        return StringsKt.endsWith$default((String)pattern2, (String)"\\.gradle\\.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)pattern2, (String)"\\.gradle\\.kts$", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)((ScriptDefinition.FromConfigurationsBase)$this$isGradleDefinition).getFileExtension(), (String)"gradle.kts", (boolean)false, (int)2, null);
    }

    private final EditorNotificationPanel createNotification(FileEditor fileEditor, Project project, List<? extends ScriptDefinition> defs) {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel $this$createNotification_u24lambda_u240 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        boolean bl = false;
        Object[] objectArray = new Object[]{((ScriptDefinition)((Object)CollectionsKt.first(defs))).getName()};
        $this$createNotification_u24lambda_u240.setText(KotlinBundle.message((String)"script.text.multiple.script.definitions.are.applicable.for.this.script", (Object[])objectArray));
        UiUtils.createComponentActionLabel($this$createNotification_u24lambda_u240, KotlinBundle.message((String)"script.action.text.show.all", (Object[])new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)arg_0 -> MultipleScriptDefinitionsChecker.createNotification$lambda$0$0(defs, arg_0)));
        $this$createNotification_u24lambda_u240.createActionLabel(KotlinBundle.message((String)"script.action.text.ignore", (Object[])new Object[0]), () -> MultipleScriptDefinitionsChecker.createNotification$lambda$0$1(project));
        $this$createNotification_u24lambda_u240.createActionLabel(KotlinBundle.message((String)"script.action.text.open.settings", (Object[])new Object[0]), () -> MultipleScriptDefinitionsChecker.createNotification$lambda$0$2(project));
        return editorNotificationPanel;
    }

    private static final boolean collectNotificationData$lambda$0(KtFile $ktFile, Project $project, ScriptDefinition it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return !it.isDefault() && it.isScript(new KtFileScriptSource($ktFile, null, 2, null)) && KotlinScriptingSettingsImpl.Companion.getInstance($project).isScriptDefinitionEnabled(it);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$2(MultipleScriptDefinitionsChecker this$0, Project $project, List $applicableDefinitions, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        return this$0.createNotification(fileEditor, $project, $applicableDefinitions);
    }

    private static final Unit createNotification$lambda$0$0(List $defs, HyperlinkLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ScriptDefinition>((List<? extends ScriptDefinition>)$defs){

            public String getTextFor(ScriptDefinition value) {
                Object object;
                block7: {
                    block6: {
                        KotlinScriptDefinition kotlinScriptDefinition;
                        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                        ScriptDefinition this_$iv = value;
                        boolean $i$f$asLegacyOrNull = false;
                        if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                            KotlinScriptDefinition kotlinScriptDefinition2 = ((ScriptDefinition.FromLegacy)this_$iv).getLegacyDefinition();
                            if (!(kotlinScriptDefinition2 instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
                                kotlinScriptDefinition2 = null;
                            }
                            kotlinScriptDefinition = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition2;
                        } else {
                            kotlinScriptDefinition = null;
                        }
                        if ((object = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition) == null) break block6;
                        KotlinScriptDefinitionFromAnnotatedTemplate it = object;
                        boolean bl = false;
                        String string = it.getName() + " (" + it.getScriptFilePattern() + ")";
                        object = string;
                        if (string != null) break block7;
                    }
                    object = value.getName() + " (" + value.getFileExtension() + ")";
                }
                Object text = object;
                return text;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        ListPopup list2 = listPopup;
        list2.showUnderneathOf((Component)label2);
        return Unit.INSTANCE;
    }

    private static final void createNotification$lambda$0$1(Project $project) {
        KotlinScriptingSettingsImpl.Companion.getInstance($project).setSuppressDefinitionsCheck(true);
        EditorNotifications.getInstance((Project)$project).updateAllNotifications();
    }

    private static final void createNotification$lambda$0$2(Project $project) {
        ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "preferences.language.Kotlin.scripting", "");
    }
}

