/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.codeInsight;

import com.intellij.model.SingleTargetReference;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.k2.codeInsight.ImportedScriptSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/codeInsight/ImportedScriptReference;", "Lcom/intellij/model/SingleTargetReference;", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "relativeFileLocation", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "resolveSingleTarget", "Lcom/intellij/model/Symbol;", "getElement", "getRangeInElement", "intellij.kotlin.base.scripting"})
public final class ImportedScriptReference
extends SingleTargetReference
implements PsiSymbolReference {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final TextRange range;
    @NotNull
    private final String relativeFileLocation;

    public ImportedScriptReference(@NotNull PsiElement element, @NotNull TextRange range2, @NotNull String relativeFileLocation) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter((Object)relativeFileLocation, (String)"relativeFileLocation");
        this.element = element;
        this.range = range2;
        this.relativeFileLocation = relativeFileLocation;
    }

    @Nullable
    protected Symbol resolveSingleTarget() {
        VirtualFile relativeFile;
        VirtualFile virtualFile = this.element.getContainingFile().getVirtualFile();
        VirtualFile virtualFile2 = virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? VirtualFileUtil.resolveFromRootOrRelative((VirtualFile)virtualFile, (String)this.relativeFileLocation) : (relativeFile = null);
        if (relativeFile != null) {
            String string = relativeFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return (Symbol)new ImportedScriptSymbol(string);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.element.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Collection collection = FilenameIndex.getVirtualFilesByName((String)this.relativeFileLocation, (GlobalSearchScope)searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        VirtualFile virtualFile3 = (VirtualFile)CollectionsKt.singleOrNull((Iterable)collection);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile absoluteFile = virtualFile3;
        String string = absoluteFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return (Symbol)new ImportedScriptSymbol(string);
    }

    @NotNull
    public PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.range;
    }
}

