/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointTypeKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.KotlinSourcePositionHighlighter;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinLineBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u00010\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0018\u0010 \u001a\u0004\u0018\u00010\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "<init>", "()V", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "matchesPosition", "", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "position", "Lcom/intellij/debugger/SourcePosition;", "getContainingMethod", "Lcom/intellij/psi/PsiElement;", "canPutAt", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "computeVariants", "", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/xdebugger/XSourcePosition;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getSourcePosition", "calculateSourcePosition", "LineKotlinBreakpointVariant", "KotlinBreakpointVariant", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n33#2,2:265\n1878#3,2:267\n1880#3:270\n1#4:269\n*S KotlinDebug\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType\n*L\n128#1:265,2\n142#1:267,2\n142#1:270\n*E\n"})
public final class KotlinLineBreakpointType
extends JavaLineBreakpointType
implements KotlinBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", KotlinDebuggerCoreBundle.message("line.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return (Breakpoint)new KotlinLineBreakpoint(project, breakpoint2);
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint2, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        JavaBreakpointProperties properties = KotlinLineBreakpointTypeKt.access$getJavaBreakpointProperties(breakpoint2);
        if (properties == null || properties instanceof JavaLineBreakpointProperties) {
            if (position instanceof KotlinReentrantSourcePosition) {
                return false;
            }
            if (properties != null && ((JavaLineBreakpointProperties)properties).isAllPositions()) {
                return true;
            }
            PsiElement psiElement = this.getContainingMethod(breakpoint2);
            if (psiElement == null) {
                return false;
            }
            PsiElement containingMethod = psiElement;
            return KotlinLineBreakpointTypeKt.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        SourcePosition sourcePosition = breakpoint2.getSourcePosition();
        return (PsiElement)(sourcePosition != null && (sourcePosition = sourcePosition.getElementAt()) != null ? KotlinPositionManagerKt.getContainingMethod$default((PsiElement)sourcePosition, false, 1, null) : null);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)arg_0 -> KotlinLineBreakpointType.canPutAt$lambda$0(file, line, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        Object element$iv2;
        LinkedList<Object> result2;
        PsiElement condRet;
        List lambdas;
        List<KtFunction> allLambdas;
        block14: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
            KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile2 == null) {
                return CollectionsKt.emptyList();
            }
            KtFile file = ktFile2;
            SourcePosition pos = SourcePosition.createFromLine((PsiFile)((PsiFile)file), (int)position.getLine());
            Intrinsics.checkNotNull((Object)pos);
            allLambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(pos);
            lambdas = KotlinLineBreakpointTypeKt.access$getLambdaBreakpointTargets(pos);
            PsiElement psiElement = condRet = JavaLineBreakpointType.canStopOnConditionalReturn((PsiFile)((PsiFile)file)) ? JavaLineBreakpointType.findSingleConditionalReturn((PsiFile)((PsiFile)file), (int)position.getLine()) : null;
            if (allLambdas.isEmpty() && condRet == null) {
                return CollectionsKt.emptyList();
            }
            result2 = new LinkedList<Object>();
            PsiElement psiElement2 = pos.getElementAt();
            if (psiElement2 != null && (psiElement2 = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement2)) != null) {
                PsiElement $this$firstIsInstance$iv = psiElement2;
                boolean $i$f$firstIsInstance = false;
                for (Object element$iv2 : $this$firstIsInstance$iv) {
                    if (!(element$iv2 instanceof KtElement)) continue;
                    break block14;
                }
                throw new NoSuchElementException("No element of given type found");
            }
            return CollectionsKt.emptyList();
        }
        KtElement elementAt = (KtElement)element$iv2;
        boolean isLambdaElement = elementAt instanceof KtFunction && (elementAt instanceof KtFunctionLiteral || ((KtFunction)elementAt).getName() == null);
        KtExpression mainMethod = KotlinPositionManagerKt.getContainingMethod((PsiElement)elementAt, isLambdaElement);
        boolean lineBreakpointAdded = false;
        if (mainMethod != null) {
            boolean isLambdaResult;
            KtExpression bodyExpression = mainMethod instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)mainMethod).getBodyExpression() : null;
            boolean bl = isLambdaResult = bodyExpression instanceof KtLambdaExpression && allLambdas.contains(((KtLambdaExpression)bodyExpression).getFunctionLiteral());
            if (!isLambdaResult) {
                result2.add((Object)new LineKotlinBreakpointVariant(position, (PsiElement)mainMethod, -1));
                lineBreakpointAdded = true;
            }
        }
        Iterable $this$forEachIndexed$iv = lambdas;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            KtExpression element;
            XSourcePositionImpl positionImpl;
            Object object;
            int ordinal;
            block16: {
                void lambda2;
                block15: {
                    KtExpression ktExpression;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    KtFunction ktFunction = (KtFunction)item$iv;
                    ordinal = n;
                    boolean bl = false;
                    object = lambda2.getBodyExpression();
                    if (object == null) break block15;
                    KtExpression it = ktExpression = object;
                    boolean bl2 = false;
                    object = it.getTextLength() > 0 ? ktExpression : null;
                    if (object != null) break block16;
                }
                object = (KtExpression)lambda2;
            }
            if ((positionImpl = XSourcePositionImpl.createByElement((PsiElement)((PsiElement)(element = object)))) == null) continue;
            result2.add(new JavaLineBreakpointType.LambdaJavaBreakpointVariant((JavaLineBreakpointType)this, (XSourcePosition)positionImpl, (PsiElement)element, ordinal));
        }
        if (lineBreakpointAdded && result2.size() > 1) {
            result2.add((Object)new KotlinBreakpointVariant(position, lambdas.size()));
        }
        if (condRet != null) {
            KtExpression method = KotlinPositionManagerKt.getContainingMethod$default(condRet, false, 1, null);
            int ordinal = CollectionsKt.indexOf((List)lambdas, (Object)method);
            result2.add(new JavaLineBreakpointType.ConditionalReturnJavaBreakpointVariant((JavaLineBreakpointType)this, position, condRet, ordinal));
        }
        return result2;
    }

    @Nullable
    public TextRange getHighlightRange(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        LineBreakpoint lineBreakpoint = breakpoint3 instanceof LineBreakpoint ? (LineBreakpoint)breakpoint3 : null;
        if (lineBreakpoint == null || (lineBreakpoint = lineBreakpoint.getSourcePosition()) == null) {
            return null;
        }
        LineBreakpoint position = lineBreakpoint;
        return new KotlinSourcePositionHighlighter().getHighlightRange((SourcePosition)position);
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        XSourcePosition xSourcePosition = this.calculateSourcePosition(breakpoint2);
        if (xSourcePosition == null) {
            xSourcePosition = super.getSourcePosition(breakpoint2);
        }
        return xSourcePosition;
    }

    private final XSourcePosition calculateSourcePosition(XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        XSourcePositionImpl xSourcePositionImpl;
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)breakpoint2.getProperties();
        if (javaLineBreakpointProperties == null) {
            return null;
        }
        JavaLineBreakpointProperties javaBreakpointProperties = javaLineBreakpointProperties;
        Intrinsics.checkNotNull(breakpoint2, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl<*>");
        SourcePosition sourcePosition = KotlinLineBreakpointTypeKt.access$createLineSourcePosition((XLineBreakpointImpl)breakpoint2);
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        if (javaBreakpointProperties.isConditionalReturn() && (xSourcePositionImpl = (XSourcePositionImpl)ActionsKt.runReadAction(() -> KotlinLineBreakpointType.calculateSourcePosition$lambda$0(sourcePosition2))) != null) {
            XSourcePositionImpl it = xSourcePositionImpl;
            boolean bl = false;
            return (XSourcePosition)it;
        }
        Integer n = javaBreakpointProperties.getLambdaOrdinal();
        if (n == null) {
            return null;
        }
        int lambdaOrdinal = n;
        KtFunction ktFunction = KotlinLineBreakpointTypeKt.access$getLambdaByOrdinal(sourcePosition2, lambdaOrdinal);
        if (ktFunction == null) {
            return null;
        }
        KtFunction function = ktFunction;
        Object object = function.getBodyBlockExpression();
        if ((object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) && (object = function.getBodyExpression()) == null) {
            return null;
        }
        Object firstStatement = object;
        return (XSourcePosition)ActionsKt.runReadAction(() -> KotlinLineBreakpointType.calculateSourcePosition$lambda$2((KtExpression)firstStatement, lambdaOrdinal));
    }

    private static final ApplicabilityResult canPutAt$lambda$0(VirtualFile $file, int $line, PsiElement element) {
        ApplicabilityResult applicabilityResult;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtDestructuringDeclaration) {
            applicabilityResult = ApplicabilityResult.MAYBE_YES;
        } else if (KotlinLineBreakpointTypeKt.access$isInsideInlineOnlyDeclaration((PsiElement)KotlinPositionManagerKt.getContainingMethod$default(element, false, 1, null))) {
            applicabilityResult = ApplicabilityResult.DEFINITELY_NO;
        } else if (KotlinLineBreakpointTypeKt.access$isClosingBraceInMethod(element)) {
            applicabilityResult = ApplicabilityResult.MAYBE_YES;
        } else if (element instanceof KtElement) {
            LineBreakpointExpressionVisitor visitor2 = LineBreakpointExpressionVisitor.Companion.of($file, $line);
            if (visitor2 != null) {
                applicabilityResult = (ApplicabilityResult)((KtElement)element).accept((KtVisitor)visitor2, null);
                if (applicabilityResult == null) {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                }
            } else {
                applicabilityResult = ApplicabilityResult.UNKNOWN;
            }
        } else {
            applicabilityResult = ApplicabilityResult.UNKNOWN;
        }
        return applicabilityResult;
    }

    private static final XSourcePositionImpl calculateSourcePosition$lambda$0(SourcePosition $sourcePosition) {
        XSourcePositionImpl xSourcePositionImpl;
        PsiElement psiElement = JavaLineBreakpointType.findSingleConditionalReturn((SourcePosition)$sourcePosition);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            xSourcePositionImpl = XSourcePositionImpl.createByElement((PsiElement)it);
        } else {
            xSourcePositionImpl = null;
        }
        return xSourcePositionImpl;
    }

    private static final XSourcePosition calculateSourcePosition$lambda$2(KtExpression $firstStatement, int $lambdaOrdinal) {
        SourcePosition sourcePosition = SourcePosition.createFromElement((PsiElement)((PsiElement)$firstStatement));
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition linePosition = sourcePosition;
        return DebuggerUtilsEx.toXSourcePosition((SourcePosition)((SourcePosition)new PositionManagerImpl.JavaSourcePosition(linePosition, $lambdaOrdinal)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "lambdaCount", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;I)V", "intellij.kotlin.jvm.debugger.core"})
    public final class KotlinBreakpointVariant
    extends JavaLineBreakpointType.JavaBreakpointVariant {
        public KotlinBreakpointVariant(XSourcePosition position, int lambdaCount) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position, lambdaCount);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "element", "Lcom/intellij/psi/PsiElement;", "lambdaOrdinal", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/psi/PsiElement;I)V", "isLowPriority", "", "firstLineElement", "intellij.kotlin.jvm.debugger.core"})
    public final class LineKotlinBreakpointVariant
    extends JavaLineBreakpointType.LineJavaBreakpointVariant {
        public LineKotlinBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, int lambdaOrdinal) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position, element, lambdaOrdinal);
        }

        protected boolean isLowPriority(@Nullable PsiElement firstLineElement) {
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)firstLineElement), (Object)KtTokens.DOT);
        }
    }
}

