/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.JavaDebuggerCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.Result;
import org.jetbrains.kotlin.nj2k.NewJavaToKotlinConverter;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtImportList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&J$\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactoryBase;", "Lcom/intellij/debugger/engine/JavaDebuggerCodeFragmentFactory;", "<init>", "()V", "registerCodeFragmentExtensions", "", "Lorg/jetbrains/kotlin/psi/KtBlockCodeFragment;", "contextElement", "Lcom/intellij/psi/PsiElement;", "createPresentationPsiCodeFragmentImpl", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "project", "Lcom/intellij/openapi/project/Project;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluatorBuilder;", "initImports", "", "imports", "fixImportIfNeeded", "import", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinCodeFragmentFactoryBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeFragmentFactoryBase.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactoryBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1617#2,9:98\n1869#2:107\n1870#2:109\n1626#2:110\n1#3:108\n*S KotlinDebug\n*F\n+ 1 KotlinCodeFragmentFactoryBase.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactoryBase\n*L\n79#1:98,9\n79#1:107\n79#1:109\n79#1:110\n79#1:108\n*E\n"})
public abstract class KotlinCodeFragmentFactoryBase
extends JavaDebuggerCodeFragmentFactory {
    public abstract void registerCodeFragmentExtensions(@NotNull KtBlockCodeFragment var1, @Nullable PsiElement var2);

    @Nullable
    protected JavaCodeFragment createPresentationPsiCodeFragmentImpl(@NotNull TextWithImports item, @Nullable PsiElement context2, @NotNull Project project) {
        KtExpressionCodeFragment convertedFragment;
        KtExpressionCodeFragment ktExpressionCodeFragment;
        PsiImportList e2;
        PsiExpression psiExpression;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JavaCodeFragment javaCodeFragment = this.createPsiCodeFragment(item, context2, project);
        if (javaCodeFragment == null) {
            return null;
        }
        JavaCodeFragment kotlinCodeFragment = javaCodeFragment;
        if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)kotlinCodeFragment)) || !(kotlinCodeFragment instanceof KtCodeFragment)) {
            return kotlinCodeFragment;
        }
        try {
            psiExpression = PsiElementFactory.getInstance((Project)project).createExpressionFromText(item.getText(), context2);
        }
        catch (IncorrectOperationException e2) {
            psiExpression = null;
        }
        PsiExpression javaExpression = psiExpression;
        try {
            PsiImportList psiImportList;
            KtImportList ktImportList = ((KtCodeFragment)kotlinCodeFragment).importsAsImportList();
            if (ktImportList != null) {
                PsiJavaFile psiJavaFile;
                KtImportList it = ktImportList;
                boolean bl = false;
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)it.getText());
                PsiJavaFile psiJavaFile2 = psiJavaFile = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
                psiImportList = psiJavaFile != null ? psiJavaFile.getImportList() : null;
            } else {
                psiImportList = null;
            }
            e2 = psiImportList;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            e2 = null;
        }
        PsiImportList importList = e2;
        try {
            KtExpressionCodeFragment ktExpressionCodeFragment2;
            PsiExpression psiExpression2 = javaExpression;
            NewJavaToKotlinConverter converter = new NewJavaToKotlinConverter(project, (Module)(psiExpression2 != null ? GenericPsiUtils.getModule((PsiElement)psiExpression2) : null), ConverterSettings.Companion.getDefaultSettings(), null, 8, null);
            Result convertedExpression = (Result)ActionUtil.underModalProgress((Project)project, (String)KotlinDebuggerEvaluationBundle.message("progress.title.converting.java.expression.to.kotlin", new Object[0]), () -> KotlinCodeFragmentFactoryBase.createPresentationPsiCodeFragmentImpl$lambda$1(converter, javaExpression));
            ElementResult elementResult = (ElementResult)CollectionsKt.singleOrNull(convertedExpression.getResults());
            String newText = elementResult != null ? elementResult.getText() : null;
            PsiImportList psiImportList = importList;
            String newImports = psiImportList != null ? psiImportList.getText() : null;
            String string = newText;
            if (string != null) {
                String it = string;
                boolean bl = false;
                String string2 = ((KtCodeFragment)kotlinCodeFragment).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                ktExpressionCodeFragment2 = new KtExpressionCodeFragment(project, string2, (CharSequence)it, newImports, ((KtCodeFragment)kotlinCodeFragment).getContext());
            } else {
                ktExpressionCodeFragment2 = null;
            }
            ktExpressionCodeFragment = ktExpressionCodeFragment2;
        }
        catch (ProcessCanceledException e3) {
            throw e3;
        }
        catch (Throwable e4) {
            PsiExpression psiExpression3 = javaExpression;
            KotlinEvaluatorBuilderKt.getLOG().error("Couldn't convert expression:\n`" + (psiExpression3 != null ? psiExpression3.getText() : null) + "`", e4);
            ktExpressionCodeFragment = null;
        }
        KtExpressionCodeFragment ktExpressionCodeFragment3 = convertedFragment = ktExpressionCodeFragment;
        return ktExpressionCodeFragment3 != null ? (JavaCodeFragment)ktExpressionCodeFragment3 : kotlinCodeFragment;
    }

    @NotNull
    public KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    public KotlinEvaluatorBuilder getEvaluatorBuilder() {
        return KotlinEvaluatorBuilder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String initImports(@Nullable String imports2) {
        String[] stringArray = (String[])imports2;
        if (!(stringArray == null || stringArray.length() == 0)) {
            void $this$mapNotNullTo$iv$iv;
            stringArray = new String[]{","};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)imports2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.fixImportIfNeeded(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        }
        return null;
    }

    private final String fixImportIfNeeded(String string) {
        if (StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null)) {
            return this.fixImportIfNeeded(((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)string, (CharSequence)"[]"))).toString());
        }
        if (!Intrinsics.areEqual((Object)PsiTypesUtil.boxIfPossible((String)string), (Object)string)) {
            return null;
        }
        return string;
    }

    private static final Result createPresentationPsiCodeFragmentImpl$lambda$1(NewJavaToKotlinConverter $converter, PsiExpression $javaExpression) {
        return $converter.elementsToKotlin(CollectionsKt.listOfNotNull((Object)$javaExpression));
    }
}

