/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.analyzers;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.symbols.KaAnonymousFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocation;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.idea.highlighting.KotlinCallHighlighterExtension;
import org.jetbrains.kotlin.idea.highlighting.analyzers.KotlinSemanticAnalyzer;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinFunctionCallSemanticAnalyzer;", "Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinSemanticAnalyzer;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expressionHighlightType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "isAssignment", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "callee", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getDefaultHighlightInfoTypeForCall", "call", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaCall;", "Companion", "intellij.kotlin.highlighting"})
@SourceDebugExtension(value={"SMAP\nKotlinFunctionCallSemanticAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFunctionCallSemanticAnalyzer.kt\norg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinFunctionCallSemanticAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n99#3:98\n67#3:99\n672#4,11:100\n*S KotlinDebug\n*F\n+ 1 KotlinFunctionCallSemanticAnalyzer.kt\norg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinFunctionCallSemanticAnalyzer\n*L\n39#1:98\n51#1:99\n51#1:100,11\n*E\n"})
public class KotlinFunctionCallSemanticAnalyzer
extends KotlinSemanticAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID;

    public KotlinFunctionCallSemanticAnalyzer(@NotNull HighlightInfoHolder holder2, @NotNull KaSession session2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(holder2, session2);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
            KtReferenceExpression ktReferenceExpression = ktOperationReferenceExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktOperationReferenceExpression : null;
            if (ktReferenceExpression == null) {
                return;
            }
            KtReferenceExpression operationReference = ktReferenceExpression;
            if (this.isAssignment(operationReference)) {
                return;
            }
            HighlightInfoType highlightInfoType = this.expressionHighlightType(expression);
            if (highlightInfoType == null) break block2;
            HighlightInfoType it = highlightInfoType;
            boolean bl = false;
            this.highlightElement((PsiElement)operationReference, it);
        }
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtExpression ktExpression = expression.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression callee = ktExpression;
            if (callee instanceof KtLambdaExpression || callee instanceof KtCallExpression) {
                return;
            }
            HighlightInfoType highlightInfoType = this.expressionHighlightType(expression, callee);
            if (highlightInfoType == null) break block2;
            HighlightInfoType it = highlightInfoType;
            boolean bl = false;
            this.highlightElement((PsiElement)callee, it);
        }
    }

    private final HighlightInfoType expressionHighlightType(KtBinaryExpression expression) {
        KaLifetimeOwner kaLifetimeOwner;
        block7: {
            block6: {
                KaSession $this$expressionHighlightType_u24lambda_u240 = this.getSession();
                boolean bl = false;
                kaLifetimeOwner = $this$expressionHighlightType_u24lambda_u240.resolveToCall((KtElement)expression);
                if (kaLifetimeOwner == null) break block6;
                KaCallInfo $this$successfulCallOrNull$iv = kaLifetimeOwner;
                boolean $i$f$successfulCallOrNull = false;
                KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                KaLifetimeOwner kaLifetimeOwner2 = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
                if (!(kaLifetimeOwner2 instanceof KaCall)) {
                    kaLifetimeOwner2 = kaLifetimeOwner = null;
                }
                if (kaLifetimeOwner2 != null) break block7;
            }
            return null;
        }
        KaLifetimeOwner call2 = kaLifetimeOwner;
        if (call2 instanceof KaSimpleFunctionCall) {
            Object s = KaCallKt.getSymbol((KaCallableMemberCall)call2);
            KaNamedFunctionSymbol kaNamedFunctionSymbol = s instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)s : null;
            boolean bl = kaNamedFunctionSymbol != null ? kaNamedFunctionSymbol.isOperator() : false;
            if (bl) {
                return null;
            }
        }
        HighlightInfoType highlightInfoType = this.getDefaultHighlightInfoTypeForCall((KaCall)call2);
        return highlightInfoType;
    }

    private final boolean isAssignment(KtReferenceExpression $this$isAssignment) {
        KtOperationReferenceExpression ktOperationReferenceExpression = $this$isAssignment instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)$this$isAssignment : null;
        return Intrinsics.areEqual((Object)(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null), (Object)KtTokens.EQ);
    }

    private final HighlightInfoType expressionHighlightType(KtCallExpression expression, KtExpression callee) {
        KaLifetimeOwner kaLifetimeOwner;
        KaSession $this$expressionHighlightType_u24lambda_u241;
        block9: {
            block8: {
                Object v1;
                block7: {
                    $this$expressionHighlightType_u24lambda_u241 = this.getSession();
                    boolean bl = false;
                    kaLifetimeOwner = $this$expressionHighlightType_u24lambda_u241.resolveToCall((KtElement)expression);
                    if (kaLifetimeOwner == null) break block8;
                    KaCallInfo $this$singleCallOrNull$iv = kaLifetimeOwner;
                    boolean $i$f$singleCallOrNull = false;
                    Iterable $this$singleOrNull$iv$iv = KaCallInfoKt.getCalls($this$singleCallOrNull$iv);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv$iv = null;
                    boolean found$iv$iv = false;
                    for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                        KaCall it$iv = (KaCall)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it$iv instanceof KaCall)) continue;
                        if (found$iv$iv) {
                            v1 = null;
                            break block7;
                        }
                        single$iv$iv = element$iv$iv;
                        found$iv$iv = true;
                    }
                    v1 = !found$iv$iv ? null : single$iv$iv;
                }
                KaCall kaCall = v1;
                kaLifetimeOwner = kaCall;
                if (kaCall != null) break block9;
            }
            return null;
        }
        KaLifetimeOwner call2 = kaLifetimeOwner;
        HighlightInfoType highlightInfoType = Companion.getHighlightInfoTypeForCallFromExtension$intellij_kotlin_highlighting($this$expressionHighlightType_u24lambda_u241, callee, (KaCall)call2);
        if (highlightInfoType == null) {
            highlightInfoType = this.getDefaultHighlightInfoTypeForCall((KaCall)call2);
        }
        return highlightInfoType;
    }

    private final HighlightInfoType getDefaultHighlightInfoTypeForCall(KaCall call2) {
        if (!(call2 instanceof KaSimpleFunctionCall)) {
            return null;
        }
        KaFunctionSymbol function = (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)call2);
        HighlightInfoType type2 = function instanceof KaConstructorSymbol ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCONSTRUCTOR_CALL() : (function instanceof KaAnonymousFunctionSymbol ? null : (function instanceof KaNamedFunctionSymbol ? (((KaNamedFunctionSymbol)function).isSuspend() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSUSPEND_FUNCTION_CALL() : (((KaSimpleFunctionCall)call2).isImplicitInvoke() ? (((KaNamedFunctionSymbol)function).isBuiltinFunctionInvoke() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getVARIABLE_AS_FUNCTION_CALL() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getVARIABLE_AS_FUNCTION_LIKE_CALL()) : (Intrinsics.areEqual((Object)function.getCallableId(), (Object)KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getKEYWORD() : (function.isExtension() ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getEXTENSION_FUNCTION_CALL() : (function.getLocation() == KaSymbolLocation.TOP_LEVEL ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPACKAGE_FUNCTION_CALL() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_CALL()))))) : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_CALL()));
        return type2;
    }

    static {
        Name name2 = Name.identifier((String)"suspend");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID = new CallableId(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, name2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinFunctionCallSemanticAnalyzer$Companion;", "", "<init>", "()V", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "getHighlightInfoTypeForCallFromExtension", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "call", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaCall;", "getHighlightInfoTypeForCallFromExtension$intellij_kotlin_highlighting", "intellij.kotlin.highlighting"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HighlightInfoType getHighlightInfoTypeForCallFromExtension$intellij_kotlin_highlighting(@NotNull KaSession $this$getHighlightInfoTypeForCallFromExtension, @NotNull KtExpression expression, @NotNull KaCall call2) {
            HighlightInfoType highlightInfoType;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$getHighlightInfoTypeForCallFromExtension, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                KaSession session2 = $this$getHighlightInfoTypeForCallFromExtension;
                for (KotlinCallHighlighterExtension it : (Iterable)KotlinCallHighlighterExtension.Companion.getEP_NAME().getExtensionList()) {
                    boolean bl = false;
                    KotlinCallHighlighterExtension $this$getHighlightInfoTypeForCallFromExtension_u24lambda_u240_u240 = it;
                    boolean bl2 = false;
                    HighlightInfoType highlightInfoType2 = $this$getHighlightInfoTypeForCallFromExtension_u24lambda_u240_u240.highlightCall(session2, (PsiElement)expression, call2);
                    if (highlightInfoType2 == null) continue;
                    highlightInfoType = highlightInfoType2;
                    break block1;
                }
                highlightInfoType = null;
            }
            HighlightInfoType highlightInfoType3 = highlightInfoType;
            return highlightInfoType3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

