/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitSuperQualifierIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "toNonQualified", "superExpression", "reformat", "", "kotlin.idea"})
public final class RemoveExplicitSuperQualifierIntention
extends SelfTargetingRangeIntention<KtSuperExpression> {
    public RemoveExplicitSuperQualifierIntention() {
        super(KtSuperExpression.class, KotlinBundle.messagePointer((String)"remove.explicit.supertype.qualification", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtSuperExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getSuperTypeQualifier() == null) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)element));
        if (ktQualifiedExpression == null) {
            return null;
        }
        KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
        KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector2 = ktExpression;
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)selector2, BodyResolveMode.PARTIAL_WITH_CFA);
        if (CallUtilKt.getResolvedCall((KtElement)((KtElement)selector2), (BindingContext)bindingContext) == null) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{this.toNonQualified(element, false), selector2};
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0.$1", (Object[])objectArray, (boolean)false);
        Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        KtQualifiedExpression newQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)newQualifiedExpression, (KtExpression)qualifiedExpression, bindingContext, null, null, null, 28, null);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)newQualifiedExpression.getSelectorExpression()), (BindingContext)newBindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall newResolvedCall = resolvedCall;
        if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)newResolvedCall.getResultingDescriptor()))) {
            return null;
        }
        KtReferenceExpression ktReferenceExpression = element.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"getInstanceReference(...)");
        KtContainerNode ktContainerNode = element.getLabelQualifier();
        return new TextRange(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktReferenceExpression)), ktContainerNode != null ? PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktContainerNode)) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element)));
    }

    @Override
    public void applyTo(@NotNull KtSuperExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.replace((PsiElement)this.toNonQualified(element, true));
    }

    private final KtSuperExpression toNonQualified(KtSuperExpression superExpression, boolean reformat) {
        KtExpression ktExpression;
        Project project = superExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        Name labelName = superExpression.getLabelNameAsName();
        if (labelName != null) {
            Object[] objectArray = new Object[]{labelName};
            ktExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)"super@$0", (Object[])objectArray, (boolean)reformat);
        } else {
            ktExpression = psiFactory.createExpression("super");
        }
        KtExpression ktExpression2 = ktExpression;
        Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperExpression");
        return (KtSuperExpression)ktExpression2;
    }
}

