/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.scratch.compile;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.compile.KtScratchExecutionSession;
import org.jetbrains.kotlin.idea.jvm.shared.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;)V", "session", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtScratchExecutionSession;", "execute", "", "stop", "checkForErrors", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "parseOutput", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "findExpression", "psiElement", "Lcom/intellij/psi/PsiElement;", "lineStart", "", "lineEnd", "ProcessOutputParser", "kotlin.jvm.k1"})
@SourceDebugExtension(value={"SMAP\nKtCompilingExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCompilingExecutor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n774#2:183\n865#2,2:184\n1869#2,2:186\n295#2,2:188\n295#2,2:190\n*S KotlinDebug\n*F\n+ 1 KtCompilingExecutor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor\n*L\n62#1:183\n62#1:184,2\n65#1:186,2\n96#1:188,2\n100#1:190,2\n*E\n"})
public final class KtCompilingExecutor
extends ScratchExecutor {
    @Nullable
    private KtScratchExecutionSession session;

    public KtCompilingExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file);
    }

    @Override
    public void execute() {
        block0: {
            this.getHandler().clear(this.getScratchFile());
            this.getHandler().onStart(this.getScratchFile());
            KtScratchExecutionSession ktScratchExecutionSession = this.session = new KtScratchExecutionSession(this.getScratchFile(), this);
            if (ktScratchExecutionSession == null) break block0;
            ktScratchExecutionSession.execute((Function0<Unit>)((Function0)() -> KtCompilingExecutor.execute$lambda$0(this)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.session == null) {
            return;
        }
        try {
            KtScratchExecutionSession ktScratchExecutionSession = this.session;
            if (ktScratchExecutionSession != null) {
                ktScratchExecutionSession.stop();
            }
        }
        finally {
            this.getHandler().onFinish(this.getScratchFile());
        }
    }

    public final boolean checkForErrors(@NotNull KtFile psiFile, @NotNull List<ScratchExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (Boolean)DumbModeUtils.runReadActionInSmartMode(project, () -> KtCompilingExecutor.checkForErrors$lambda$0(psiFile, this, expressions));
    }

    public final void parseOutput(@NotNull ProcessOutput processOutput, @NotNull List<ScratchExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        new ProcessOutputParser(expressions).parse(processOutput);
    }

    private final ScratchExpression findExpression(List<ScratchExpression> $this$findExpression, PsiElement psiElement) {
        int elementLine = PsiLinesUtilsKt.getLineNumber$default(psiElement, false, 1, null);
        return (ScratchExpression)ActionsKt.runReadAction(() -> KtCompilingExecutor.findExpression$lambda$0($this$findExpression, elementLine));
    }

    private final ScratchExpression findExpression(List<ScratchExpression> $this$findExpression, int lineStart, int lineEnd) {
        return (ScratchExpression)ActionsKt.runReadAction(() -> KtCompilingExecutor.findExpression$lambda$1($this$findExpression, lineStart, lineEnd));
    }

    private static final Unit execute$lambda$0(KtCompilingExecutor this$0) {
        this$0.getHandler().onFinish(this$0.getScratchFile());
        this$0.session = null;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkForErrors$lambda$0(KtFile $psiFile, KtCompilingExecutor this$0, List $expressions) {
        void $this$filterTo$iv$iv;
        try {
            AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)$psiFile));
        }
        catch (IllegalArgumentException e) {
            ScratchExecutor scratchExecutor = this$0;
            String string = e.getMessage();
            if (string == null) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)$psiFile.getName(), (String)"getName(...)");
                string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
            }
            ScratchExecutor.errorOccurs$default(scratchExecutor, string, null, true, 2, null);
            return false;
        }
        AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks($psiFile, new KtFile[0]);
        if (analysisResult.isError()) {
            ScratchExecutor scratchExecutor = this$0;
            String string = analysisResult.getError().getMessage();
            if (string == null) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)$psiFile.getName(), (String)"getName(...)");
                string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
            }
            ScratchExecutor.errorOccurs$default(scratchExecutor, string, null, true, 2, null);
            return false;
        }
        BindingContext bindingContext = analysisResult.getBindingContext();
        Diagnostics diagnostics = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
        Iterable $this$filter$iv = (Iterable)diagnostics;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Diagnostic it = (Diagnostic)element$iv$iv;
            boolean bl = false;
            if (!(it.getSeverity() == Severity.ERROR)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List diagnostics2 = (List)destination$iv$iv;
        if (!((Collection)diagnostics2).isEmpty()) {
            PsiFile scratchPsiFile = this$0.getScratchFile().getPsiFile();
            Iterable $this$forEach$iv = diagnostics2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String errorText;
                Diagnostic diagnostic = (Diagnostic)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic)), (String)"render(...)");
                if (Intrinsics.areEqual((Object)$psiFile, (Object)scratchPsiFile)) {
                    if (Intrinsics.areEqual((Object)diagnostic.getPsiElement().getContainingFile(), (Object)$psiFile)) {
                        ScratchExpression scratchExpression = this$0.findExpression($expressions, diagnostic.getPsiElement());
                        if (scratchExpression == null) {
                            ScratchUtilsKt.getLOG().error("Couldn't find expression to report error: " + PsiUtilsKt.getElementTextWithContext((PsiElement)diagnostic.getPsiElement()));
                            this$0.getHandler().error(this$0.getScratchFile(), errorText);
                            continue;
                        }
                        this$0.getHandler().handle(this$0.getScratchFile(), scratchExpression, new ScratchOutput(errorText, ScratchOutputType.ERROR));
                        continue;
                    }
                    this$0.getHandler().error(this$0.getScratchFile(), errorText);
                    continue;
                }
                this$0.getHandler().error(this$0.getScratchFile(), errorText);
            }
            this$0.getHandler().onFinish(this$0.getScratchFile());
            return false;
        }
        return true;
    }

    private static final ScratchExpression findExpression$lambda$0(List $this_findExpression, int $elementLine) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = $this_findExpression;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScratchExpression it = (ScratchExpression)element$iv;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = $elementLine <= it.getLineEnd() ? n <= $elementLine : false;
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final ScratchExpression findExpression$lambda$1(List $this_findExpression, int $lineStart, int $lineEnd) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this_findExpression;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScratchExpression it = (ScratchExpression)element$iv;
                boolean bl = false;
                if (!(it.getLineStart() == $lineStart && it.getLineEnd() == $lineEnd)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor$ProcessOutputParser;", "", "expressions", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor;Ljava/util/List;)V", "parse", "", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "parseStdOut", "out", "", "isOutputEnd", "", "line", "isResultEnd", "isGeneratedOutput", "extractLineInfoFrom", "Lkotlin/Pair;", "", "encoded", "kotlin.jvm.k1"})
    @SourceDebugExtension(value={"SMAP\nKtCompilingExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCompilingExecutor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor$ProcessOutputParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1869#2,2:183\n1869#2,2:185\n*S KotlinDebug\n*F\n+ 1 KtCompilingExecutor.kt\norg/jetbrains/kotlin/idea/jvm/k1/scratch/compile/KtCompilingExecutor$ProcessOutputParser\n*L\n141#1:183,2\n145#1:185,2\n*E\n"})
    private final class ProcessOutputParser {
        @NotNull
        private final List<ScratchExpression> expressions;

        public ProcessOutputParser(List<ScratchExpression> expressions) {
            Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
            this.expressions = expressions;
        }

        public final void parse(@NotNull ProcessOutput processOutput) {
            Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
            String string = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String out = string;
            String string2 = processOutput.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            String err = string2;
            if (!StringsKt.isBlank((CharSequence)err)) {
                KtCompilingExecutor.this.getHandler().error(KtCompilingExecutor.this.getScratchFile(), err);
            }
            if (!StringsKt.isBlank((CharSequence)out)) {
                this.parseStdOut(out);
            }
        }

        private final void parseStdOut(String out) {
            ArrayList<String> results2 = new ArrayList<String>();
            ArrayList<String> userOutput = new ArrayList<String>();
            String[] stringArray = new String[]{"\n"};
            for (String line : StringsKt.split$default((CharSequence)out, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Compiling executor output: " + line);
                if (this.isOutputEnd(line)) {
                    return;
                }
                if (this.isGeneratedOutput(line)) {
                    String lineWoPrefix = StringsKt.removePrefix((String)line, (CharSequence)"##scratch##generated##");
                    if (this.isResultEnd(lineWoPrefix)) {
                        int endLine;
                        Pair<Integer, Integer> extractedLineInfo;
                        if (this.extractLineInfoFrom(lineWoPrefix) == null) {
                            Object[] objectArray = new Object[]{lineWoPrefix};
                            ScratchExecutor.errorOccurs$default(KtCompilingExecutor.this, KotlinJvmBundle.message("couldn.t.extract.line.info.from.line.0", objectArray), null, true, 2, null);
                            return;
                        }
                        int startLine = ((Number)extractedLineInfo.component1()).intValue();
                        ScratchExpression scratchExpression = KtCompilingExecutor.this.findExpression(this.expressions, startLine, endLine = ((Number)extractedLineInfo.component2()).intValue());
                        if (scratchExpression == null) {
                            ScratchUtilsKt.getLOG().error("Couldn't find expression with start line = " + startLine + ", end line = " + endLine + ".\n" + CollectionsKt.joinToString$default((Iterable)this.expressions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                        } else {
                            Iterable $this$forEach$iv;
                            Iterable iterable = userOutput;
                            KtCompilingExecutor ktCompilingExecutor = KtCompilingExecutor.this;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String output = (String)element$iv;
                                boolean bl = false;
                                ktCompilingExecutor.getHandler().handle(ktCompilingExecutor.getScratchFile(), scratchExpression, new ScratchOutput(output, ScratchOutputType.OUTPUT));
                            }
                            $this$forEach$iv = results2;
                            ktCompilingExecutor = KtCompilingExecutor.this;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String result2 = (String)element$iv;
                                boolean bl = false;
                                ktCompilingExecutor.getHandler().handle(ktCompilingExecutor.getScratchFile(), scratchExpression, new ScratchOutput(result2, ScratchOutputType.RESULT));
                            }
                        }
                        results2 = new ArrayList();
                        userOutput = new ArrayList();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)lineWoPrefix, (Object)Unit.INSTANCE.toString())) continue;
                    results2.add(lineWoPrefix);
                    continue;
                }
                userOutput.add(line);
            }
        }

        private final boolean isOutputEnd(String line) {
            return Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)line, (CharSequence)"\n"), (Object)"end##!@#%^&*");
        }

        private final boolean isResultEnd(String line) {
            return StringsKt.startsWith$default((String)line, (String)"end##", (boolean)false, (int)2, null);
        }

        private final boolean isGeneratedOutput(String line) {
            return StringsKt.startsWith$default((String)line, (String)"##scratch##generated##", (boolean)false, (int)2, null);
        }

        private final Pair<Integer, Integer> extractLineInfoFrom(String encoded) {
            Object object = new char[]{'|'};
            List lineInfo = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)encoded, (CharSequence)"end##"), (CharSequence)"\n"), (char[])object, (boolean)false, (int)0, (int)6, null);
            if (lineInfo.size() == 2) {
                try {
                    object = TuplesKt.to((Object)Integer.parseInt((String)lineInfo.get(0)), (Object)Integer.parseInt((String)lineInfo.get(1)));
                    int a = ((Number)object.component1()).intValue();
                    int b = ((Number)object.component2()).intValue();
                    if (a > -1 && b > -1) {
                        return TuplesKt.to((Object)a, (Object)b);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

