/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.DestructureInspectionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.UsagesToRemove;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.UseDestructureDeclarationFix;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\u0002H\u0016J \u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0003*\u00020\u00182\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/DestructureInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/UsagesToRemove;", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "isApplicableByPsi", "", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "intellij.kotlin.codeInsight.inspections"})
public final class DestructureInspection
extends KotlinApplicableInspectionBase.Simple<KtDeclaration, UsagesToRemove> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtDeclaration element, @NotNull UsagesToRemove context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"use.destructuring.declaration", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtDeclaration> createQuickFix(@NotNull KtDeclaration element, @NotNull UsagesToRemove context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new UseDestructureDeclarationFix(context2);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return DestructureInspectionKt.access$getUsageScopeElement(element) != null;
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtDeclaration element) {
        TextRange textRange;
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtDeclaration ktDeclaration = element;
        if (ktDeclaration instanceof KtFunctionLiteral) {
            object = ((KtFunctionLiteral)element).getLBrace().getTextRange();
        } else if (ktDeclaration instanceof KtNamedDeclaration) {
            PsiElement psiElement = ((KtNamedDeclaration)element).getNameIdentifier();
            object = psiElement != null ? psiElement.getTextRange() : null;
        } else {
            object = null;
        }
        TextRange textRange2 = textRange = object;
        return CollectionsKt.listOfNotNull(textRange2 != null ? textRange2.shiftLeft(element.getTextRange().getStartOffset()) : null);
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ DestructureInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitExpression(KtExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (expression instanceof KtFunctionLiteral) {
                    DestructureInspection.access$visitTargetElement(this.this$0, (KtDeclaration)expression, this.$holder, this.$isOnTheFly);
                }
            }

            public void visitDeclaration(KtDeclaration dcl) {
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                DestructureInspection.access$visitTargetElement(this.this$0, dcl, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @Nullable
    public UsagesToRemove prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return DestructureInspectionKt.access$collectUsagesToRemove($this$prepareContext, element);
    }

    public static final /* synthetic */ void access$visitTargetElement(DestructureInspection $this, KtDeclaration element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

