/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ScriptShebangExecPermissionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "MakeExecutable", "intellij.kotlin.codeInsight.inspections"})
public final class ScriptShebangExecPermissionInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitKtFile(KtFile file) {
                Object v1;
                block5: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!file.isScript()) {
                        return;
                    }
                    PsiElement[] psiElementArray = file.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    Object[] $this$filterIsInstance$iv = psiElementArray;
                    boolean $i$f$filterIsInstance = false;
                    Object[] objectArray = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiComment)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        PsiComment it = (PsiComment)element$iv;
                        boolean bl = false;
                        if (!(it.getTokenType() == KtTokens.SHEBANG_COMMENT)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                PsiComment psiComment = v1;
                if (psiComment == null) {
                    return;
                }
                PsiComment shebang = psiComment;
                Path path2 = Paths.get(file.getVirtualFilePath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                if (Files.isExecutable(path2)) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new MakeExecutable(file.getVirtualFilePath())};
                this.$holder.registerProblem((PsiElement)shebang, KotlinBundle.message((String)"script.not.executable.missing.execute.permission", (Object[])new Object[0]), ProblemHighlightType.WARNING, localQuickFixArray);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ScriptShebangExecPermissionInspection$MakeExecutable;", "Lcom/intellij/codeInspection/LocalQuickFix;", "virtualFilePath", "", "<init>", "(Ljava/lang/String;)V", "getVirtualFilePath", "()Ljava/lang/String;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "", "intellij.kotlin.codeInsight.inspections"})
    public static final class MakeExecutable
    implements LocalQuickFix {
        @NotNull
        private final String virtualFilePath;

        public MakeExecutable(@NotNull String virtualFilePath) {
            Intrinsics.checkNotNullParameter((Object)virtualFilePath, (String)"virtualFilePath");
            this.virtualFilePath = virtualFilePath;
        }

        @NotNull
        public final String getVirtualFilePath() {
            return this.virtualFilePath;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"make.script.executable", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            new File(this.virtualFilePath).setExecutable(true);
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

