/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.k2.copyPaste;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.copyPaste.ConversionResult;
import org.jetbrains.kotlin.j2k.copyPaste.CopyPasteConversionUtilsKt;
import org.jetbrains.kotlin.j2k.copyPaste.ElementAndTextList;
import org.jetbrains.kotlin.j2k.copyPaste.J2KCopyPasteConverter;
import org.jetbrains.kotlin.j2k.copyPaste.TargetData;
import org.jetbrains.kotlin.j2k.k2.copyPaste.K2J2KCopyPasteConverterKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/j2k/k2/copyPaste/K2J2KCopyPasteConverter;", "Lorg/jetbrains/kotlin/j2k/copyPaste/J2KCopyPasteConverter;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "elementsAndTexts", "Lorg/jetbrains/kotlin/j2k/copyPaste/ElementAndTextList;", "targetData", "Lorg/jetbrains/kotlin/j2k/copyPaste/TargetData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/j2k/copyPaste/ElementAndTextList;Lorg/jetbrains/kotlin/j2k/copyPaste/TargetData;)V", "result", "Lorg/jetbrains/kotlin/j2k/k2/copyPaste/K2J2KCopyPasteConverter$Result;", "convert", "", "convertAndRestoreReferencesIfTextIsUnchanged", "", "insertImports", "Lcom/intellij/openapi/util/TextRange;", "bounds", "importsToAdd", "", "Lorg/jetbrains/kotlin/name/FqName;", "Result", "intellij.kotlin.j2k"})
public final class K2J2KCopyPasteConverter
implements J2KCopyPasteConverter {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final ElementAndTextList elementsAndTexts;
    @NotNull
    private final TargetData targetData;
    private Result result;

    public K2J2KCopyPasteConverter(@NotNull Project project, @NotNull Editor editor, @NotNull ElementAndTextList elementsAndTexts, @NotNull TargetData targetData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)elementsAndTexts, (String)"elementsAndTexts");
        Intrinsics.checkNotNullParameter((Object)targetData, (String)"targetData");
        this.project = project;
        this.editor = editor;
        this.elementsAndTexts = elementsAndTexts;
        this.targetData = targetData;
    }

    @Override
    public void convert() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.result == null && this.convertAndRestoreReferencesIfTextIsUnchanged()) {
            return;
        }
        Result result2 = this.result;
        if (result2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            result2 = null;
        }
        Result result3 = result2;
        String changedText = result3.component1();
        Set<FqName> importsToAdd = result3.component2();
        ConverterContext converterContext = result3.component3();
        if (changedText == null) {
            K2J2KCopyPasteConverterKt.access$getLOG$p().error("'changedText' is null, this is a logical error: the case with unchanged text should have been handled by `convertAndRestoreReferencesIfTextIsUnchanged`");
            return;
        }
        int endOffsetAfterReplace = this.targetData.getBounds().getStartOffset() + changedText.length();
        TextRange boundsAfterReplace = new TextRange(this.targetData.getBounds().getStartOffset(), endOffsetAfterReplace);
        ActionsKt.runWriteAction(() -> K2J2KCopyPasteConverter.convert$lambda$0(this, changedText, endOffsetAfterReplace));
        TextRange newBounds = this.insertImports(boundsAfterReplace, (Collection<FqName>)importsToAdd);
        CopyPasteConversionUtilsKt.runPostProcessing(this.project, this.targetData.getFile(), newBounds, converterContext, J2kConverterExtension.Kind.K2);
    }

    @Override
    public boolean convertAndRestoreReferencesIfTextIsUnchanged() {
        ThreadingAssertions.assertEventDispatchThread();
        ConversionResult conversionResult = CopyPasteConversionUtilsKt.convertCodeToKotlin(this.elementsAndTexts, this.project, this.targetData.getFile(), J2kConverterExtension.Kind.K2);
        String text = conversionResult.component1();
        Set<FqName> importsToAdd = conversionResult.component3();
        boolean isTextChanged = conversionResult.component4();
        ConverterContext converterContext = conversionResult.component5();
        String changedText = isTextChanged ? text : null;
        this.result = new Result(changedText, importsToAdd, converterContext);
        Result result2 = this.result;
        if (result2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            result2 = null;
        }
        if (result2.getChangedText() != null) {
            return false;
        }
        TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)this.targetData.getBounds());
        if (textRange == null) {
            return true;
        }
        TextRange boundsTextRange = textRange;
        Result result3 = this.result;
        if (result3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            result3 = null;
        }
        this.insertImports(boundsTextRange, (Collection<FqName>)result3.getImportsToAdd());
        return true;
    }

    private final TextRange insertImports(TextRange bounds, Collection<FqName> importsToAdd) {
        RangeMarker rangeMarker;
        if (importsToAdd.isEmpty()) {
            return bounds;
        }
        RangeMarker $this$insertImports_u24lambda_u240 = rangeMarker = this.targetData.getDocument().createRangeMarker(bounds);
        boolean bl = false;
        $this$insertImports_u24lambda_u240.setGreedyToLeft(true);
        $this$insertImports_u24lambda_u240.setGreedyToRight(true);
        RangeMarker rangeMarker2 = rangeMarker;
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"apply(...)");
        RangeMarker rangeMarker3 = rangeMarker2;
        ActionsKt.runWriteAction(() -> K2J2KCopyPasteConverter.insertImports$lambda$1(importsToAdd, this));
        return RangeMarkersKt.getAsTextRange((RangeMarker)rangeMarker3);
    }

    private static final Unit convert$lambda$0(K2J2KCopyPasteConverter this$0, String $changedText, int $endOffsetAfterReplace) {
        this$0.targetData.getDocument().replaceString(this$0.targetData.getBounds().getStartOffset(), this$0.targetData.getBounds().getEndOffset(), (CharSequence)$changedText);
        this$0.editor.getCaretModel().moveToOffset($endOffsetAfterReplace);
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument(this$0.targetData.getDocument());
        return Unit.INSTANCE;
    }

    private static final Unit insertImports$lambda$1(Collection $importsToAdd, K2J2KCopyPasteConverter this$0) {
        for (FqName fqName2 : $importsToAdd) {
            ImportInsertionKt.addImport$default(this$0.targetData.getFile(), fqName2, false, null, null, 14, null);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/j2k/k2/copyPaste/K2J2KCopyPasteConverter$Result;", "", "changedText", "", "importsToAdd", "", "Lorg/jetbrains/kotlin/name/FqName;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "<init>", "(Ljava/lang/String;Ljava/util/Set;Lorg/jetbrains/kotlin/j2k/ConverterContext;)V", "getChangedText", "()Ljava/lang/String;", "getImportsToAdd", "()Ljava/util/Set;", "getConverterContext", "()Lorg/jetbrains/kotlin/j2k/ConverterContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.j2k"})
    private static final class Result {
        @Nullable
        private final String changedText;
        @NotNull
        private final Set<FqName> importsToAdd;
        @Nullable
        private final ConverterContext converterContext;

        public Result(@Nullable String changedText, @NotNull Set<FqName> importsToAdd, @Nullable ConverterContext converterContext) {
            Intrinsics.checkNotNullParameter(importsToAdd, (String)"importsToAdd");
            this.changedText = changedText;
            this.importsToAdd = importsToAdd;
            this.converterContext = converterContext;
        }

        @Nullable
        public final String getChangedText() {
            return this.changedText;
        }

        @NotNull
        public final Set<FqName> getImportsToAdd() {
            return this.importsToAdd;
        }

        @Nullable
        public final ConverterContext getConverterContext() {
            return this.converterContext;
        }

        @Nullable
        public final String component1() {
            return this.changedText;
        }

        @NotNull
        public final Set<FqName> component2() {
            return this.importsToAdd;
        }

        @Nullable
        public final ConverterContext component3() {
            return this.converterContext;
        }

        @NotNull
        public final Result copy(@Nullable String changedText, @NotNull Set<FqName> importsToAdd, @Nullable ConverterContext converterContext) {
            Intrinsics.checkNotNullParameter(importsToAdd, (String)"importsToAdd");
            return new Result(changedText, importsToAdd, converterContext);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, Set set, ConverterContext converterContext, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.changedText;
            }
            if ((n & 2) != 0) {
                set = result2.importsToAdd;
            }
            if ((n & 4) != 0) {
                converterContext = result2.converterContext;
            }
            return result2.copy(string, set, converterContext);
        }

        @NotNull
        public String toString() {
            return "Result(changedText=" + this.changedText + ", importsToAdd=" + this.importsToAdd + ", converterContext=" + this.converterContext + ")";
        }

        public int hashCode() {
            int result2 = this.changedText == null ? 0 : this.changedText.hashCode();
            result2 = result2 * 31 + ((Object)this.importsToAdd).hashCode();
            result2 = result2 * 31 + (this.converterContext == null ? 0 : this.converterContext.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.changedText, (Object)result2.changedText)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.importsToAdd, result2.importsToAdd)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.converterContext, (Object)result2.converterContext);
        }
    }
}

