/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntheticElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.nj2k.ConversionsKt;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.symbols.JKClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseMethodSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArrayAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKClassAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFieldAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKForInStatement;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKKtAssignmentStatement;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.tree.TreeUtilsKt;
import org.jetbrains.kotlin.nj2k.types.JKClassType;
import org.jetbrains.kotlin.nj2k.types.JKType;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\f\u0010\t\u001a\u00020\u0007*\u00020\u0007H\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\f\u0010\u0011\u001a\u00020\u000b*\u00020\u0007H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0007H\u0002J\f\u0010\u0014\u001a\u00020\u000b*\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u000b*\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/EnumSyntheticValuesMethodConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "selector", "isReceiverEnumType", "", "convert", "enumClassSymbol", "Lorg/jetbrains/kotlin/nj2k/symbols/JKClassSymbol;", "Lorg/jetbrains/kotlin/nj2k/symbols/JKMultiverseMethodSymbol;", "canChangeReturnTypeFromArrayToList", "isUsedAsAssignmentTarget", "getNextCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKExpression;", "isArrayGetCall", "isArraySizeCall", "rebindArraySymbolsToListSymbols", "", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nEnumSyntheticValuesMethodConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumSyntheticValuesMethodConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/EnumSyntheticValuesMethodConversion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,105:1\n125#2:106\n18#2,2:107\n125#2:109\n*S KotlinDebug\n*F\n+ 1 EnumSyntheticValuesMethodConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/EnumSyntheticValuesMethodConversion\n*L\n43#1:106\n79#1:107,2\n84#1:109\n*E\n"})
public final class EnumSyntheticValuesMethodConversion
extends RecursiveConversion {
    public EnumSyntheticValuesMethodConversion(@NotNull ConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKQualifiedExpression) && !(element instanceof JKCallExpression)) {
            return this.recurse(element);
        }
        if (!ConversionsKt.getLanguageVersionSettings(this).supportsFeature(LanguageFeature.EnumEntries)) {
            return this.recurse(element);
        }
        JKSymbol jKSymbol = ExpressionsKt.getIdentifier(this.selector(element));
        if (jKSymbol == null) {
            return this.recurse(element);
        }
        JKSymbol identifier = jKSymbol;
        if (!Intrinsics.areEqual((Object)identifier.getName(), (Object)"values")) {
            return this.recurse(element);
        }
        if (!(identifier.getTarget() instanceof SyntheticElement)) {
            return this.recurse(element);
        }
        return this.isReceiverEnumType(element) ? this.recurse(this.convert(element)) : this.recurse(element);
    }

    private final JKTreeElement selector(JKTreeElement $this$selector) {
        return $this$selector instanceof JKQualifiedExpression ? (JKTreeElement)((JKQualifiedExpression)$this$selector).getSelector() : $this$selector;
    }

    private final boolean isReceiverEnumType(JKTreeElement $this$isReceiverEnumType) {
        boolean bl;
        JKTreeElement jKTreeElement = $this$isReceiverEnumType;
        if (jKTreeElement instanceof JKQualifiedExpression) {
            JKSymbol jKSymbol = ExpressionsKt.getIdentifier(((JKQualifiedExpression)$this$isReceiverEnumType).getReceiver());
            bl = jKSymbol != null ? TypesUtilsKt.isEnumType(jKSymbol) : false;
        } else if (jKTreeElement instanceof JKCallExpression) {
            Object object;
            JKType $this$safeAs$iv = ((JKCallExpression)$this$isReceiverEnumType).getIdentifier().getReceiverType();
            boolean $i$f$safeAs = false;
            JKType jKType = $this$safeAs$iv;
            if (!(jKType instanceof JKClassType)) {
                jKType = null;
            }
            bl = (object = (JKClassType)jKType) != null && (object = ((JKClassType)object).getClassReference()) != null ? TypesUtilsKt.isEnumType((JKSymbol)object) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final JKTreeElement convert(JKTreeElement element) {
        JKSymbol jKSymbol = ExpressionsKt.getIdentifier(this.selector(element));
        JKSymbol jKSymbol2 = jKSymbol instanceof JKMultiverseMethodSymbol ? (JKMultiverseMethodSymbol)jKSymbol : null;
        if (jKSymbol2 == null || (jKSymbol2 = this.enumClassSymbol((JKMultiverseMethodSymbol)jKSymbol2)) == null) {
            return element;
        }
        JKSymbol enumClassSymbol = jKSymbol2;
        JKQualifiedExpression entriesCall = (JKQualifiedExpression)FormattingKt.withFormattingFrom((JKFormattingOwner)new JKQualifiedExpression(new JKClassAccessExpression((JKClassSymbol)enumClassSymbol, null, 2, null), new JKFieldAccessExpression(this.getSymbolProvider().provideFieldSymbol(enumClassSymbol.getFqName() + ".entries"), null, 2, null), null, 4, null), (JKFormattingOwner)element);
        if (this.canChangeReturnTypeFromArrayToList(element)) {
            this.rebindArraySymbolsToListSymbols(element);
            return entriesCall;
        }
        return ExpressionsKt.callOn$default(entriesCall, this.getSymbolProvider().provideMethodSymbol("kotlin.collections.toTypedArray"), null, null, null, false, 30, null);
    }

    private final JKClassSymbol enumClassSymbol(JKMultiverseMethodSymbol $this$enumClassSymbol) {
        PsiClass psiClass = $this$enumClassSymbol.getTarget().getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass containingClass = psiClass;
        JKSymbol jKSymbol = $this$enumClassSymbol.getSymbolProvider().provideDirectSymbol((PsiElement)containingClass);
        return jKSymbol instanceof JKClassSymbol ? (JKClassSymbol)jKSymbol : null;
    }

    private final boolean canChangeReturnTypeFromArrayToList(JKTreeElement element) {
        if (element.getParent() instanceof JKForInStatement) {
            return true;
        }
        if (this.isUsedAsAssignmentTarget(element)) {
            return false;
        }
        if (element.getParent() instanceof JKArrayAccessExpression) {
            return true;
        }
        JKExpression jKExpression = this.getNextCall(element);
        if (jKExpression == null) {
            return false;
        }
        JKExpression nextCall = jKExpression;
        return this.isArrayGetCall(nextCall) || this.isArraySizeCall(nextCall);
    }

    private final boolean isUsedAsAssignmentTarget(JKTreeElement $this$isUsedAsAssignmentTarget) {
        JKKtAssignmentStatement upperParent;
        Object v0;
        block1: {
            Sequence $this$firstIsInstanceOrNull$iv = SequencesKt.take(TreeUtilsKt.parents($this$isUsedAsAssignmentTarget), (int)2);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof JKKtAssignmentStatement)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        JKKtAssignmentStatement jKKtAssignmentStatement = upperParent = (JKKtAssignmentStatement)v0;
        return Intrinsics.areEqual((Object)(jKKtAssignmentStatement != null ? jKKtAssignmentStatement.getField() : null), (Object)$this$isUsedAsAssignmentTarget.getParent());
    }

    private final JKExpression getNextCall(JKTreeElement $this$getNextCall) {
        JKElement $this$safeAs$iv = $this$getNextCall.getParent();
        boolean $i$f$safeAs = false;
        JKElement jKElement = $this$safeAs$iv;
        if (!(jKElement instanceof JKQualifiedExpression)) {
            jKElement = null;
        }
        JKQualifiedExpression jKQualifiedExpression = (JKQualifiedExpression)jKElement;
        return jKQualifiedExpression != null ? jKQualifiedExpression.getSelector() : null;
    }

    private final boolean isArrayGetCall(JKExpression $this$isArrayGetCall) {
        return $this$isArrayGetCall instanceof JKCallExpression && Intrinsics.areEqual((Object)((JKCallExpression)$this$isArrayGetCall).getIdentifier().getFqName(), (Object)"kotlin.Array.get");
    }

    private final boolean isArraySizeCall(JKExpression $this$isArraySizeCall) {
        return $this$isArraySizeCall instanceof JKFieldAccessExpression && Intrinsics.areEqual((Object)((JKFieldAccessExpression)$this$isArraySizeCall).getIdentifier().getFqName(), (Object)"kotlin.Array.size");
    }

    private final void rebindArraySymbolsToListSymbols(JKTreeElement element) {
        JKExpression jKExpression = this.getNextCall(element);
        if (jKExpression == null) {
            return;
        }
        JKExpression nextCall = jKExpression;
        if (this.isArraySizeCall(nextCall)) {
            ((JKFieldAccessExpression)nextCall).setIdentifier(this.getSymbolProvider().provideFieldSymbol("kotlin.collections.List.size"));
        } else if (this.isArrayGetCall(nextCall)) {
            ((JKCallExpression)nextCall).setIdentifier(this.getSymbolProvider().provideMethodSymbol("kotlin.collections.List.get"));
        }
    }
}

