/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.resolve;

import com.intellij.debugger.streams.core.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.wrapper.TraceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/streams/core/resolve/PrependResolver;", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver;", "<init>", "()V", "resolve", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "intellij.debugger.streams.core"})
@SourceDebugExtension(value={"SMAP\nPrependResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrependResolver.kt\ncom/intellij/debugger/streams/core/resolve/PrependResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n360#2,7:33\n*S KotlinDebug\n*F\n+ 1 PrependResolver.kt\ncom/intellij/debugger/streams/core/resolve/PrependResolver\n*L\n21#1:33,7\n*E\n"})
public final class PrependResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        Intrinsics.checkNotNull(valuesBefore);
        if (!((Collection)valuesBefore).isEmpty()) {
            int indexOfFirstItemFromSource;
            block5: {
                int n;
                TraceElement firstBefore = (TraceElement)CollectionsKt.first(valuesBefore);
                Intrinsics.checkNotNull(valuesAfter);
                List<TraceElement> $this$indexOfFirst$iv = valuesAfter;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<TraceElement> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    TraceElement item$iv;
                    TraceElement it = item$iv = iterator.next();
                    boolean bl = false;
                    if (it.getTime() > firstBefore.getTime()) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = indexOfFirstItemFromSource = -1;
            }
            if (indexOfFirstItemFromSource != -1) {
                for (Pair pair : CollectionsKt.zip((Iterable)valuesBefore, (Iterable)valuesAfter.subList(indexOfFirstItemFromSource, valuesAfter.size()))) {
                    TraceElement before = (TraceElement)pair.component1();
                    TraceElement after = (TraceElement)pair.component2();
                    Map map = direct;
                    Object object = new TraceElement[1];
                    Intrinsics.checkNotNull((Object)after);
                    object[0] = after;
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(before, object);
                    map = reverse;
                    object = new TraceElement[1];
                    Intrinsics.checkNotNull((Object)before);
                    object[0] = before;
                    object = CollectionsKt.mutableListOf((Object[])object);
                    map.put(after, object);
                }
            }
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"of(...)");
        return result;
    }
}

