/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.xml.XmlPropertiesFileImpl;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesImplUtil
extends PropertiesUtil {
    @NotNull
    public static ResourceBundleWithCachedFiles getResourceBundleWithCachedFiles(@NotNull PropertiesFile representative) {
        if (representative == null) {
            PropertiesImplUtil.$$$reportNull$$$0(0);
        }
        ResourceBundleWithCachedFiles resourceBundleWithCachedFiles = (ResourceBundleWithCachedFiles)ReadAction.compute(() -> {
            PsiFile containingFile = representative.getContainingFile();
            if (!containingFile.isValid()) {
                return ResourceBundleWithCachedFiles.EMPTY;
            }
            ResourceBundleManager manager = ResourceBundleManager.getInstance(representative.getProject());
            CustomResourceBundle customResourceBundle = manager.getCustomResourceBundle(representative);
            if (customResourceBundle != null) {
                return new ResourceBundleWithCachedFiles(customResourceBundle, customResourceBundle.getPropertiesFiles());
            }
            VirtualFile virtualFile = representative.getVirtualFile();
            if (virtualFile == null) {
                return ResourceBundleWithCachedFiles.EMPTY;
            }
            if (manager.isDefaultDissociated(virtualFile)) {
                return new ResourceBundleWithCachedFiles(new ResourceBundleImpl(representative), Collections.singletonList(representative));
            }
            String baseName = manager.getBaseName(containingFile);
            String extension = containingFile.getVirtualFile().getExtension();
            PsiDirectory directory = containingFile.getContainingDirectory();
            if (directory == null) {
                return ResourceBundleWithCachedFiles.EMPTY;
            }
            ResourceBundleWithCachedFiles bundle = PropertiesImplUtil.getResourceBundle(baseName, extension, directory);
            return bundle == null ? new ResourceBundleWithCachedFiles(new ResourceBundleImpl(representative), Collections.singletonList(representative)) : bundle;
        });
        if (resourceBundleWithCachedFiles == null) {
            PropertiesImplUtil.$$$reportNull$$$0(1);
        }
        return resourceBundleWithCachedFiles;
    }

    @NotNull
    public static List<PropertiesFile> getResourceBundleFiles(@NotNull PropertiesFile representative) {
        if (representative == null) {
            PropertiesImplUtil.$$$reportNull$$$0(2);
        }
        List<PropertiesFile> list = PropertiesImplUtil.getResourceBundleWithCachedFiles(representative).getFiles();
        if (list == null) {
            PropertiesImplUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull PropertiesFile representative) {
        if (representative == null) {
            PropertiesImplUtil.$$$reportNull$$$0(4);
        }
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundleWithCachedFiles(representative).getBundle();
        if (resourceBundle == null) {
            PropertiesImplUtil.$$$reportNull$$$0(5);
        }
        return resourceBundle;
    }

    @Nullable
    private static ResourceBundleWithCachedFiles getResourceBundle(@NotNull String baseName, @Nullable String extension, @NotNull PsiDirectory baseDirectory) {
        if (baseName == null) {
            PropertiesImplUtil.$$$reportNull$$$0(6);
        }
        if (baseDirectory == null) {
            PropertiesImplUtil.$$$reportNull$$$0(7);
        }
        ResourceBundleManager bundleBaseNameManager = ResourceBundleManager.getInstance(baseDirectory.getProject());
        List<PropertiesFile> bundleFiles = Stream.of(baseDirectory.isValid() ? baseDirectory.getFiles() : PsiFile.EMPTY_ARRAY).filter(f -> PropertiesImplUtil.isPropertiesFile(f) && Comparing.strEqual((String)f.getVirtualFile().getExtension(), (String)extension) && Objects.equals(bundleBaseNameManager.getBaseName((PsiFile)f), baseName)).map(PropertiesImplUtil::getPropertiesFile).collect(Collectors.toList());
        if (bundleFiles.isEmpty()) {
            return null;
        }
        return new ResourceBundleWithCachedFiles(new ResourceBundleImpl((PropertiesFile)bundleFiles.get(0)), bundleFiles);
    }

    public static boolean isPropertiesFile(@Nullable PsiFile file) {
        return PropertiesImplUtil.getPropertiesFile(file) != null;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PropertiesImplUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PropertiesImplUtil.$$$reportNull$$$0(9);
        }
        return PropertiesImplUtil.getPropertiesFile(PsiManager.getInstance((Project)project).findFile(file));
    }

    @Contract(value="null -> null")
    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiFile file) {
        if (!PropertiesImplUtil.canBePropertyFile(file)) {
            return null;
        }
        return file instanceof PropertiesFile ? (PropertiesFile)file : XmlPropertiesFileImpl.getPropertiesFile(file);
    }

    public static boolean canBePropertyFile(PsiFile file) {
        return file instanceof PropertiesFile || file instanceof XmlFile && file.getFileType() == XmlFileType.INSTANCE;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        return PropertiesImplUtil.getPropertiesFile((PsiFile)element);
    }

    @NotNull
    public static List<IProperty> findPropertiesByKey(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            PropertiesImplUtil.$$$reportNull$$$0(10);
        }
        if (key == null) {
            PropertiesImplUtil.$$$reportNull$$$0(11);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        ArrayList<Property> properties = new ArrayList<Property>(PropertyKeyIndex.getInstance().getProperties(key, project, scope));
        HashSet files = new HashSet();
        FileBasedIndex.getInstance().processValues(XmlPropertiesIndex.NAME, (Object)new XmlPropertiesIndex.Key(key), null, (file, value) -> {
            PropertiesFile propertiesFile;
            PsiFile psiFile;
            if (files.add(file) && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null && (propertiesFile = XmlPropertiesFileImpl.getPropertiesFile(psiFile)) != null) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
            return true;
        }, scope);
        ArrayList<Property> arrayList = properties;
        if (arrayList == null) {
            PropertiesImplUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    public static ResourceBundle createByUrl(@NotNull String url, @NotNull Project project) {
        int idx;
        if (url == null) {
            PropertiesImplUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PropertiesImplUtil.$$$reportNull$$$0(14);
        }
        if ((idx = url.lastIndexOf(47)) == -1) {
            return null;
        }
        String baseDirectoryName = url.substring(0, idx);
        String baseName = url.substring(idx + 1);
        VirtualFile baseDirectoryVirtualFile = VirtualFileManager.getInstance().findFileByUrl(baseDirectoryName);
        if (baseDirectoryVirtualFile == null) {
            return null;
        }
        PsiDirectory baseDirectory = PsiManager.getInstance((Project)project).findDirectory(baseDirectoryVirtualFile);
        if (baseDirectory == null) {
            return null;
        }
        ResourceBundleManager bundleBaseNameManager = ResourceBundleManager.getInstance(project);
        for (PsiFile file : baseDirectory.getFiles()) {
            String currBaseName;
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
            if (propertiesFile == null || !(currBaseName = bundleBaseNameManager.getBaseName(file)).equals(baseName)) continue;
            return PropertiesImplUtil.getResourceBundle(propertiesFile);
        }
        return null;
    }

    @Nullable
    public static IProperty getProperty(@Nullable PsiElement element) {
        PomTarget target;
        if (element instanceof IProperty) {
            return (IProperty)element;
        }
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof XmlProperty) {
            return (IProperty)target;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "representative";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesImplUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundleWithCachedFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundleFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertiesByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundleWithCachedFiles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundleFiles";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPropertiesByKey";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createByUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 12 -> new IllegalStateException(string);
        };
    }

    public static final class ResourceBundleWithCachedFiles {
        private static final ResourceBundleWithCachedFiles EMPTY = new ResourceBundleWithCachedFiles(EmptyResourceBundle.getInstance(), Collections.emptyList());
        private final ResourceBundle myBundle;
        private final List<PropertiesFile> myFiles;

        private ResourceBundleWithCachedFiles(@NotNull ResourceBundle bundle, @NotNull List<PropertiesFile> files) {
            if (bundle == null) {
                ResourceBundleWithCachedFiles.$$$reportNull$$$0(0);
            }
            if (files == null) {
                ResourceBundleWithCachedFiles.$$$reportNull$$$0(1);
            }
            this.myBundle = bundle;
            this.myFiles = files;
        }

        @NotNull
        public ResourceBundle getBundle() {
            ResourceBundle resourceBundle = this.myBundle;
            if (resourceBundle == null) {
                ResourceBundleWithCachedFiles.$$$reportNull$$$0(2);
            }
            return resourceBundle;
        }

        @NotNull
        public List<PropertiesFile> getFiles() {
            List<PropertiesFile> list = this.myFiles;
            if (list == null) {
                ResourceBundleWithCachedFiles.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundle";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/PropertiesImplUtil$ResourceBundleWithCachedFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/PropertiesImplUtil$ResourceBundleWithCachedFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBundle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

