/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Arrays;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualTo;
import org.assertj.core.error.ShouldBeInTheFuture;
import org.assertj.core.error.ShouldBeInThePast;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public class AbstractInstantAssert<SELF extends AbstractInstantAssert<SELF>>
extends AbstractTemporalAssert<SELF, Instant> {
    protected AbstractInstantAssert(Instant actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(Instant other) {
        AbstractInstantAssert.assertNotNull(this.info, (Instant)this.actual);
        AbstractInstantAssert.assertInstantParameterIsNotNull(other);
        if (!((Instant)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isBefore(String instantAsString) {
        AbstractInstantAssert.assertInstantAsStringParameterIsNotNull(instantAsString);
        return this.isBefore(this.parse(instantAsString));
    }

    public SELF isBeforeOrEqualTo(Instant other) {
        AbstractInstantAssert.assertNotNull(this.info, (Instant)this.actual);
        AbstractInstantAssert.assertInstantParameterIsNotNull(other);
        if (((Instant)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualTo.shouldBeBeforeOrEqualTo(this.actual, other));
        }
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String instantAsString) {
        AbstractInstantAssert.assertInstantAsStringParameterIsNotNull(instantAsString);
        return this.isBeforeOrEqualTo(this.parse(instantAsString));
    }

    public SELF isAfterOrEqualTo(Instant other) {
        AbstractInstantAssert.assertNotNull(this.info, (Instant)this.actual);
        AbstractInstantAssert.assertInstantParameterIsNotNull(other);
        if (((Instant)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualTo.shouldBeAfterOrEqualTo(this.actual, other));
        }
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String instantAsString) {
        AbstractInstantAssert.assertInstantAsStringParameterIsNotNull(instantAsString);
        return this.isAfterOrEqualTo(this.parse(instantAsString));
    }

    public SELF isAfter(Instant other) {
        AbstractInstantAssert.assertNotNull(this.info, (Instant)this.actual);
        AbstractInstantAssert.assertInstantParameterIsNotNull(other);
        if (!((Instant)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isAfter(String instantAsString) {
        AbstractInstantAssert.assertInstantAsStringParameterIsNotNull(instantAsString);
        return this.isAfter(this.parse(instantAsString));
    }

    public SELF isEqualTo(String instantAsString) {
        AbstractInstantAssert.assertInstantAsStringParameterIsNotNull(instantAsString);
        return (SELF)((AbstractInstantAssert)this.isEqualTo(this.parse(instantAsString)));
    }

    public SELF isNotEqualTo(String instantAsString) {
        AbstractInstantAssert.assertInstantAsStringParameterIsNotNull(instantAsString);
        return (SELF)((AbstractInstantAssert)this.isNotEqualTo(this.parse(instantAsString)));
    }

    public SELF isIn(String ... instantsAsString) {
        this.checkIsNotNullAndNotEmpty(instantsAsString);
        return (SELF)((AbstractInstantAssert)this.isIn(AbstractInstantAssert.convertToInstantArray(instantsAsString)));
    }

    public SELF isNotIn(String ... instantsAsString) {
        this.checkIsNotNullAndNotEmpty(instantsAsString);
        return (SELF)((AbstractInstantAssert)this.isNotIn(AbstractInstantAssert.convertToInstantArray(instantsAsString)));
    }

    public SELF isInThePast() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((Instant)this.actual).isBefore(Instant.now())) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeInThePast.shouldBeInThePast((Temporal)this.actual));
        }
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isInTheFuture() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((Instant)this.actual).isAfter(Instant.now())) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeInTheFuture.shouldBeInTheFuture((Temporal)this.actual));
        }
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isBetween(Instant startInclusive, Instant endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(Instant startExclusive, Instant endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractInstantAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    @Override
    protected Instant parse(String instantAsString) {
        return Instant.parse(instantAsString);
    }

    private static Object[] convertToInstantArray(String[] instantsAsString) {
        return Arrays.stream(instantsAsString).map(Instant::parse).toArray();
    }

    private static void assertNotNull(AssertionInfo info, Instant actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given Instant array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given Instant array should not be empty", new Object[0]);
    }

    private static void assertInstantAsStringParameterIsNotNull(String instantAsString) {
        Preconditions.checkArgument(instantAsString != null, "The String representing the Instant to compare actual with should not be null", new Object[0]);
    }

    private static void assertInstantParameterIsNotNull(Instant instant) {
        Preconditions.checkArgument(instant != null, "The Instant to compare actual with should not be null", new Object[0]);
    }
}

