/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLTokenAdapter;

public class SQLRuleScanner
extends RuleBasedScanner
implements TPCharacterScanner {
    @NotNull
    private final IThemeManager themeManager;
    private final HashMap<SQLTokenType, IToken> extraSyntaxTokens = new HashMap();
    private SQLEditorBase editor = null;
    private final Map<TPToken, IToken> tokenMap = new IdentityHashMap<TPToken, IToken>();
    private int keywordStyle = 0;
    private static final boolean DEBUG = false;

    public SQLRuleScanner() {
        this.themeManager = PlatformUI.getWorkbench().getThemeManager();
    }

    public int getKeywordStyle() {
        return this.keywordStyle;
    }

    public void dispose() {
    }

    public void refreshRules(@Nullable DBPDataSourceContainer dataSourceContainer, SQLRuleManager ruleManager, SQLEditorBase editor) {
        this.tokenMap.clear();
        boolean boldKeywords = dataSourceContainer == null ? DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.format.boldKeywords") : dataSourceContainer.getPreferenceStore().getBoolean("SQLEditor.format.boldKeywords");
        this.keywordStyle = boldKeywords ? 1 : 0;
        TPRule[] allRules = ruleManager.getAllRules();
        IRule[] result = new IRule[allRules.length];
        int i = 0;
        while (i < allRules.length) {
            result[i] = this.adaptRule(allRules[i]);
            ++i;
        }
        this.setRules(result);
        this.editor = editor;
        this.extraSyntaxTokens.clear();
    }

    private IRule adaptRule(TPRule rule) {
        if (rule instanceof TPPredicateRule) {
            return new PredicateRuleAdapter((TPPredicateRule)rule);
        }
        return new SimpleRuleAdapter(this, rule);
    }

    private IToken adaptToken(TPToken token) {
        if (token.isEOF()) {
            return Token.EOF;
        }
        if (token.isUndefined()) {
            return Token.UNDEFINED;
        }
        if (token.isWhitespace()) {
            return Token.WHITESPACE;
        }
        Object jfToken = this.tokenMap.get(token);
        if (jfToken == null) {
            jfToken = new SQLTokenAdapter(token, this);
            this.tokenMap.put(token, (IToken)jfToken);
        }
        return jfToken;
    }

    public Color getColor(String colorKey) {
        return this.getColor(colorKey, 2);
    }

    private Color getColor(String colorKey, int colorDefault) {
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        Color color = currentTheme.getColorRegistry().get(colorKey);
        if (color == null) {
            color = Display.getDefault().getSystemColor(colorDefault);
        }
        return color;
    }

    public int getOffset() {
        return this.fOffset;
    }

    private IToken tryResolveExtraToken() {
        SQLDocumentSyntaxContext syntaxContext;
        SQLDocumentSyntaxContext sQLDocumentSyntaxContext = syntaxContext = this.editor == null ? null : this.editor.getSyntaxContext();
        if (syntaxContext == null) {
            return Token.UNDEFINED;
        }
        int offset = this.getOffset();
        SQLQuerySymbolEntry entry = syntaxContext.findToken(offset);
        if (entry != null) {
            int end = syntaxContext.getLastAccessedTokenOffset() + entry.getInterval().length();
            if (end > offset) {
                while (this.getOffset() < end) {
                    if (super.read() != -1) continue;
                    return Token.UNDEFINED;
                }
                return this.extraSyntaxTokens.computeIfAbsent(entry.getSymbolClass().getTokenType(), tt -> new SQLTokenAdapter((TPToken)new LazyToken((TPTokenType)tt), this));
            }
            return Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    public IToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        IToken token = this.tryResolveExtraToken();
        if (!token.isUndefined()) {
            return token;
        }
        return super.nextToken();
    }

    private static class LazyToken
    extends TPTokenDefault {
        public LazyToken(TPTokenType type) {
            super(type);
        }
    }

    private class PredicateRuleAdapter
    extends SimpleRuleAdapter<TPPredicateRule>
    implements IPredicateRule {
        PredicateRuleAdapter(TPPredicateRule rule) {
            super(SQLRuleScanner.this, (TPRule)rule);
        }

        public IToken getSuccessToken() {
            return SQLRuleScanner.this.adaptToken(((TPPredicateRule)this.rule).getSuccessToken());
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return SQLRuleScanner.this.adaptToken(((TPPredicateRule)this.rule).evaluate((TPCharacterScanner)scanner, resume));
        }

        @Override
        public IToken evaluate(ICharacterScanner scanner) {
            return SQLRuleScanner.this.adaptToken(((TPPredicateRule)this.rule).evaluate((TPCharacterScanner)scanner));
        }

        public String toString() {
            return "Adapter of [" + ((TPPredicateRule)this.rule).toString() + "]";
        }
    }

    private static class SimpleRuleAdapter<RULE extends TPRule>
    implements IRule {
        protected final RULE rule;
        final /* synthetic */ SQLRuleScanner this$0;

        SimpleRuleAdapter(RULE rule) {
            this.this$0 = var1_1;
            this.rule = rule;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return this.this$0.adaptToken(this.rule.evaluate((TPCharacterScanner)scanner));
        }
    }
}

