/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.cmd.Command;
import tim.prune.cmd.EditPositionsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.PointUtils;
import tim.prune.function.edit.PointEdit;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.RadioButtonGroup;
import tim.prune.gui.WholeNumberField;

public class ProjectRange
extends GenericFunction {
    private JDialog _dialog = null;
    private WholeNumberField _bearingField = null;
    private JLabel _distanceDescLabel = null;
    private DecimalNumberField _distanceField = null;
    private boolean _distanceIsMetric = true;
    private JRadioButton _createNewRadio = null;
    private JButton _okButton = null;

    public ProjectRange(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.projectrange";
    }

    @Override
    public void begin() {
        if (!this.checkSelection()) {
            return;
        }
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._bearingField.setText("");
        this._distanceField.setText("");
        this.setLabelText();
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private boolean checkSelection() {
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        return n >= 0 && n2 > n;
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.projectcircle.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._bearingField = new WholeNumberField(3);
        this._distanceField = new DecimalNumberField(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ProjectRange.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    ProjectRange.this._dialog.dispose();
                } else if (keyEvent.getKeyCode() == 10 && ProjectRange.this._okButton.isEnabled()) {
                    ProjectRange.this.finish();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ProjectRange.this.enableOK();
            }
        };
        this._bearingField.addKeyListener(keyAdapter);
        this._bearingField.addMouseListener(mouseAdapter);
        this._distanceField.addKeyListener(keyAdapter);
        this._distanceField.addMouseListener(mouseAdapter);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.projectpoint.bearing"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._bearingField);
        this._distanceDescLabel = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + " (ft)");
        this._distanceDescLabel.setHorizontalAlignment(4);
        guiGridLayout.add(this._distanceDescLabel);
        guiGridLayout.add(this._distanceField);
        this._createNewRadio = new JRadioButton(I18nManager.getText("dialog.projectrange.createcopies"));
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.projectrange.editexisting"));
        new RadioButtonGroup(this._createNewRadio, jRadioButton);
        this._createNewRadio.setSelected(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(this._createNewRadio);
        jPanel3.add(jRadioButton);
        guiGridLayout.add(jPanel3, 2, false);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> {
            if (this._okButton.isEnabled()) {
                this.finish();
            }
        });
        this._okButton.setEnabled(false);
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void setLabelText() {
        this._distanceIsMetric = this.getConfig().getUnitSet().isMetric();
        Unit unit = this._distanceIsMetric ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        String string = unit.getShortnameKey();
        this._distanceDescLabel.setText(String.valueOf(I18nManager.getText("fieldname.distance")) + " (" + I18nManager.getText(string) + ")");
    }

    private void enableOK() {
        boolean bl = this._distanceField.getValue() > 0.0;
        this._okButton.setEnabled(bl);
    }

    private void finish() {
        Unit unit = this._distanceIsMetric ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        double d = Distance.convertDistanceToRadians(this._distanceField.getValue(), unit);
        double d2 = Math.toRadians(this._bearingField.getValue());
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        if (n < 0 || n2 <= n) {
            return;
        }
        Command command = this._createNewRadio != null && this._createNewRadio.isSelected() ? this.makeAppendCommand(n, n2, d, d2) : this.makeEditCommand(n, n2, d, d2);
        this._app.execute(command);
        this._dialog.dispose();
    }

    private Command makeAppendCommand(int n, int n2, double d, double d2) {
        Track track = this._app.getTrackInfo().getTrack();
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = track.getPoint(n3);
            DataPoint dataPoint2 = PointUtils.projectPoint(dataPoint, d2, d);
            dataPoint2.setSegmentStart(n3 == n || dataPoint.getSegmentStart());
            if (dataPoint.isWaypoint()) {
                dataPoint2.setWaypointName(String.valueOf(dataPoint.getWaypointName()) + "'");
            }
            if (dataPoint.hasAltitude()) {
                dataPoint2.setAltitude(dataPoint.getAltitude());
            }
            arrayList.add(dataPoint2);
            ++n3;
        }
        AppendRangeCmd appendRangeCmd = new AppendRangeCmd(arrayList);
        appendRangeCmd.setDescription(this.getName());
        appendRangeCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.pointsadded", arrayList.size()));
        return appendRangeCmd;
    }

    private Command makeEditCommand(int n, int n2, double d, double d2) {
        ArrayList<PointEdit> arrayList = new ArrayList<PointEdit>();
        ArrayList<PointEdit> arrayList2 = new ArrayList<PointEdit>();
        Track track = this._app.getTrackInfo().getTrack();
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = track.getPoint(n3);
            DataPoint dataPoint2 = PointUtils.projectPoint(dataPoint, d2, d);
            arrayList.add(new PointEdit(n3, dataPoint2.getFieldValue(Field.LATITUDE)));
            arrayList2.add(new PointEdit(n3, dataPoint2.getFieldValue(Field.LONGITUDE)));
            ++n3;
        }
        EditPositionsCmd editPositionsCmd = new EditPositionsCmd(arrayList, arrayList2);
        editPositionsCmd.setDescription(this.getName());
        int n4 = n2 - n + 1;
        editPositionsCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.pointsedited", n4));
        return editPositionsCmd;
    }
}

