/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.util.ArrayList;
import java.util.TimeZone;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.data.Distance;
import tim.prune.data.Timestamp;
import tim.prune.data.Unit;
import tim.prune.function.comparesegments.DateForTable;
import tim.prune.function.comparesegments.Duration;
import tim.prune.function.comparesegments.SegmentSummary;

public class SegmentTableModel
extends AbstractTableModel {
    private ArrayList<SegmentSummary> _segmentList = null;
    private Unit _distUnits = null;
    private ArrayList<TableValues> _tableValuesList = null;
    private static final int NUM_COLUMNS = 4;

    public void init(ArrayList<SegmentSummary> arrayList, TimeZone timeZone, Unit unit) {
        this._segmentList = arrayList;
        this._distUnits = unit;
        this._tableValuesList = new ArrayList();
        for (SegmentSummary segmentSummary : arrayList) {
            this._tableValuesList.add(new TableValues(segmentSummary, timeZone, unit));
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this._segmentList == null ? 0 : this._segmentList.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return DateForTable.class;
        }
        if (n == 2) {
            return Double.class;
        }
        if (n == 3) {
            return Duration.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            TableValues tableValues = this._tableValuesList.get(n);
            return tableValues.getValue(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Unknown column: " + n2);
        }
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nManager.getText("dialog.comparesegments.startdate");
        }
        if (n == 1) {
            return I18nManager.getText("dialog.comparesegments.starttime");
        }
        if (n == 2) {
            if (this._distUnits == null) {
                return I18nManager.getText("fieldname.distance");
            }
            return String.valueOf(I18nManager.getText("fieldname.distance")) + " (" + I18nManager.getText(this._distUnits.getShortnameKey()) + ")";
        }
        if (n == 3) {
            return I18nManager.getText("fieldname.duration");
        }
        throw new IllegalArgumentException("Unknown column: " + n);
    }

    int getSegmentStartIndex(int n) {
        return this._segmentList.get(n).getStartIndex();
    }

    boolean areSegmentsInTimeOrder(int n, int n2) {
        Timestamp timestamp = this._segmentList.get(n).getStartTimestamp();
        Timestamp timestamp2 = this._segmentList.get(n2).getStartTimestamp();
        return timestamp.isBefore(timestamp2);
    }

    private static class TableValues {
        private final Object[] _values = new Object[4];

        private TableValues(SegmentSummary segmentSummary, TimeZone timeZone, Unit unit) {
            this._values[0] = new DateForTable(segmentSummary.getStartTimestamp(), timeZone);
            this._values[1] = segmentSummary.getStartTimestamp().getTimeText(timeZone);
            this._values[2] = Distance.convertRadiansToDistance(segmentSummary.getDistanceInRadians(), unit);
            this._values[3] = new Duration(segmentSummary.getDurationInSeconds());
        }

        private Object getValue(int n) {
            return this._values[n];
        }
    }
}

