/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.filters.ReRunSyncFilter;
import org.jetbrains.plugins.gradle.execution.filters.ReRunTaskFilter;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecutionConsoleManager
extends DefaultExternalSystemExecutionConsoleManager {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleExecutionConsoleManager.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler2) {
        Filter[] filters;
        if (project == null) {
            GradleExecutionConsoleManager.$$$reportNull$$$0(1);
        }
        if (task == null) {
            GradleExecutionConsoleManager.$$$reportNull$$$0(2);
        }
        ConsoleView executionConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        executionConsole.attachToProcess(processHandler2);
        for (Filter filter : filters = this.getCustomExecutionFilters(project, task, env)) {
            executionConsole.addMessageFilter(filter);
        }
        return executionConsole;
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            GradleExecutionConsoleManager.$$$reportNull$$$0(3);
        }
        return GradleConstants.SYSTEM_ID.equals((Object)task.getId().getProjectSystemId());
    }

    public Filter[] getCustomExecutionFilters(@NotNull Project project, @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env) {
        if (project == null) {
            GradleExecutionConsoleManager.$$$reportNull$$$0(4);
        }
        if (task == null) {
            GradleExecutionConsoleManager.$$$reportNull$$$0(5);
        }
        if (task instanceof ExternalSystemExecuteTaskTask) {
            return new Filter[]{new ReRunTaskFilter((ExternalSystemExecuteTaskTask)task, env)};
        }
        if (task instanceof ExternalSystemResolveProjectTask) {
            return new Filter[]{new ReRunSyncFilter((ExternalSystemResolveProjectTask)task, project)};
        }
        return Filter.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleExecutionConsoleManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachExecutionConsole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomExecutionFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

