/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFileImpl;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlProperty
implements IProperty,
PomRenameableTarget,
PsiTarget {
    @NotNull
    private final XmlTag myTag;
    private final XmlPropertiesFileImpl myPropertiesFile;

    public XmlProperty(@NotNull XmlTag tag, XmlPropertiesFileImpl xmlPropertiesFile) {
        if (tag == null) {
            XmlProperty.$$$reportNull$$$0(0);
        }
        this.myTag = tag;
        this.myPropertiesFile = xmlPropertiesFile;
    }

    public String getName() {
        return this.myTag.getAttributeValue("key");
    }

    public boolean isWritable() {
        return this.myTag.isWritable();
    }

    public PsiElement setName(@NotNull String name) {
        if (name == null) {
            XmlProperty.$$$reportNull$$$0(1);
        }
        return this.myTag.setAttribute("key", name);
    }

    public String getKey() {
        return this.getName();
    }

    public String getValue() {
        return this.myTag.getValue().getText();
    }

    public String getUnescapedValue() {
        return this.getValue();
    }

    public String getUnescapedKey() {
        return this.getKey();
    }

    public void setValue(@NonNls @NotNull String value) throws IncorrectOperationException {
        if (value == null) {
            XmlProperty.$$$reportNull$$$0(2);
        }
        this.myTag.getValue().setText(value);
    }

    public PropertiesFile getPropertiesFile() throws PsiInvalidElementAccessException {
        return this.myPropertiesFile;
    }

    public String getDocCommentText() {
        return null;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiElement psiElement = PomService.convertToPsi((PsiTarget)this);
        if (psiElement == null) {
            XmlProperty.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.PROPERTY_ICON;
    }

    public boolean isValid() {
        return this.myTag.isValid();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            XmlProperty.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlProperty property = (XmlProperty)o;
        return this.myTag.equals(property.myTag);
    }

    public int hashCode() {
        return this.myTag.hashCode();
    }

    public String toString() {
        return "XmlProperty: key = '" + this.getKey() + "', value = '" + this.getValue() + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/xml/XmlProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/xml/XmlProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

