/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UseOfObsoleteAssertInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String name = (String)infos[0];
        String string = JUnitBundle.message("use.of.obsolete.assert.problem.descriptor", name);
        if (string == null) {
            UseOfObsoleteAssertInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceObsoleteAssertsFix();
    }

    public BaseInspectionVisitor buildVisitor() {
        return new UseOfObsoleteAssertVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInspection/UseOfObsoleteAssertInspection", "buildErrorString"));
    }

    private static class ReplaceObsoleteAssertsFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceObsoleteAssertsFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiParameter[] parameters;
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project).findClass("org.junit.Assert", GlobalSearchScope.allScope((Project)project));
            PsiClass oldAssertClass = JavaPsiFacade.getInstance((Project)project).findClass("junit.framework.Assert", GlobalSearchScope.allScope((Project)project));
            if (newAssertClass == null) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiElement usedImport = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).advancedResolve(true).getCurrentFileResolveScope() : methodExpression.advancedResolve(true).getCurrentFileResolveScope();
            PsiMethod psiMethod = call.resolveMethod();
            boolean isImportUnused = ReplaceObsoleteAssertsFix.isImportBecomeUnused(call, usedImport, psiMethod);
            PsiImportStaticStatement staticStatement = null;
            if (qualifierExpression == null) {
                staticStatement = ReplaceObsoleteAssertsFix.staticallyImported(oldAssertClass, methodExpression);
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            if (staticStatement == null) {
                methodExpression.setQualifierExpression((PsiExpression)JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(newAssertClass));
                if (isImportUnused && usedImport instanceof PsiImportStatementBase) {
                    usedImport.delete();
                }
                styleManager.shortenClassReferences((PsiElement)methodExpression);
            } else if (isImportUnused) {
                PsiJavaCodeReferenceElement importReference = staticStatement.getImportReference();
                if (importReference != null) {
                    if (staticStatement.isOnDemand()) {
                        importReference.bindToElement((PsiElement)newAssertClass);
                    } else {
                        PsiElement importQExpression = importReference.getQualifier();
                        if (importQExpression instanceof PsiJavaCodeReferenceElement) {
                            ((PsiJavaCodeReferenceElement)importQExpression).bindToElement((PsiElement)newAssertClass);
                        }
                    }
                }
            } else {
                methodExpression.setQualifierExpression((PsiExpression)JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(newAssertClass));
                styleManager.shortenClassReferences((PsiElement)methodExpression);
            }
            PsiMethod newTarget = call.resolveMethod();
            if (newTarget != null && newTarget.isDeprecated() && (parameters = newTarget.getParameterList().getParameters()).length > 0) {
                PsiType paramType = parameters[parameters.length - 1].getType();
                if (PsiTypes.doubleType().equals((Object)paramType) || PsiTypes.floatType().equals((Object)paramType)) {
                    call.getArgumentList().add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("0.0", (PsiElement)call));
                }
            }
        }

        private static boolean isImportBecomeUnused(final PsiMethodCallExpression methodCallExpression, final PsiElement usedImport, final PsiMethod psiMethod) {
            final boolean[] proceed = new boolean[]{true};
            methodCallExpression.getContainingFile().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (proceed[0]) {
                        super.visitElement(element);
                    }
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitMethodCallExpression(expression);
                    if (expression == methodCallExpression) {
                        return;
                    }
                    PsiMethod resolved = expression.resolveMethod();
                    if (resolved == psiMethod) {
                        proceed[0] = false;
                    } else {
                        PsiElement resolveScope = expression.getMethodExpression().advancedResolve(false).getCurrentFileResolveScope();
                        if (resolveScope == usedImport) {
                            proceed[0] = false;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/junit/codeInspection/UseOfObsoleteAssertInspection$ReplaceObsoleteAssertsFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodCallExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return proceed[0];
        }

        @Nullable
        private static PsiImportStaticStatement staticallyImported(PsiClass oldAssertClass, PsiReferenceExpression methodExpression) {
            PsiImportStaticStatement[] statements;
            String referenceName = methodExpression.getReferenceName();
            PsiFile containingFile = methodExpression.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return null;
            }
            PsiImportList importList = ((PsiJavaFile)containingFile).getImportList();
            if (importList == null) {
                return null;
            }
            for (PsiImportStaticStatement statement : statements = importList.getImportStaticStatements()) {
                PsiElement qualifier;
                if (oldAssertClass != statement.resolveTargetClass()) continue;
                String importRefName = statement.getReferenceName();
                PsiJavaCodeReferenceElement importReference = statement.getImportReference();
                if (importReference == null || !(Comparing.strEqual((String)importRefName, (String)referenceName) ? (qualifier = importReference.getQualifier()) instanceof PsiJavaCodeReferenceElement : importRefName == null)) continue;
                return statement;
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            String string = JUnitBundle.message("use.of.obsolete.assert.quickfix", new Object[0]);
            if (string == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/junit/codeInspection/UseOfObsoleteAssertInspection$ReplaceObsoleteAssertsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/junit/codeInspection/UseOfObsoleteAssertInspection$ReplaceObsoleteAssertsFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class UseOfObsoleteAssertVisitor
    extends BaseInspectionVisitor {
        private UseOfObsoleteAssertVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                UseOfObsoleteAssertVisitor.$$$reportNull$$$0(0);
            }
            Project project = expression.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
            if (module == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project).findClass("org.junit.Assert", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            if (newAssertClass == null) {
                return;
            }
            PsiMethod psiMethod = expression.resolveMethod();
            if (psiMethod == null || !psiMethod.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = containingClass.getQualifiedName();
            if ("junit.framework.Assert".equals(name) || "junit.framework.TestCase".equals(name)) {
                this.registerMethodCallError(expression, new Object[]{name});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/execution/junit/codeInspection/UseOfObsoleteAssertInspection$UseOfObsoleteAssertVisitor", "visitMethodCallExpression"));
        }
    }
}

