/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.NamedArgumentInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

final class MapArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final ElementPattern<PsiElement> IN_ARGUMENT_LIST_OF_CALL = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrArgumentList.class), PlatformPatterns.psiElement().withParent(GrArgumentList.class), PlatformPatterns.psiElement(GrListOrMap.class)})));
    public static final ElementPattern<PsiElement> IN_LABEL = PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mIDENT).withParent(GrArgumentLabel.class);

    private MapArgumentCompletionProvider() {
    }

    public static void register(CompletionContributor contributor) {
        MapArgumentCompletionProvider instance = new MapArgumentCompletionProvider();
        contributor.extend(CompletionType.BASIC, IN_ARGUMENT_LIST_OF_CALL, (CompletionProvider)instance);
        contributor.extend(CompletionType.BASIC, IN_LABEL, (CompletionProvider)instance);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement mapOrArgumentList;
        if (parameters == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters)) == null) {
            return;
        }
        if (MapArgumentCompletionProvider.isMapKeyCompletion(parameters)) {
            result2.stopHere();
        }
        HashMap<String, NamedArgumentDescriptor> map2 = new HashMap<String, NamedArgumentDescriptor>(MapArgumentCompletionProvider.calculateNamedArguments(mapOrArgumentList));
        for (GrNamedArgument argument : MapArgumentCompletionProvider.getSiblingNamedArguments(mapOrArgumentList)) {
            map2.remove(argument.getLabelName());
        }
        for (Map.Entry entry : map2.entrySet()) {
            LookupElementBuilder lookup = LookupElementBuilder.create(entry.getValue(), (String)((String)entry.getKey())).withInsertHandler((InsertHandler)NamedArgumentInsertHandler.INSTANCE).withTailText(":");
            if (((NamedArgumentDescriptor)entry.getValue()).getPriority() == NamedArgumentDescriptor.Priority.UNLIKELY) {
                Color fg;
                TextAttributes defaultAttributes = GroovySyntaxHighlighter.MAP_KEY.getDefaultAttributes();
                if (defaultAttributes != null && (fg = defaultAttributes.getForegroundColor()) != null) {
                    lookup = lookup.withItemTextForeground(fg);
                }
            } else {
                lookup = lookup.withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Property));
            }
            LookupElement customized = ((NamedArgumentDescriptor)entry.getValue()).customizeLookupElement(lookup);
            result2.addElement((LookupElement)(customized == null ? lookup : customized));
        }
    }

    public static boolean isMapKeyCompletion(CompletionParameters parameters) {
        PsiElement mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters);
        return mapOrArgumentList instanceof GrListOrMap && ((GrListOrMap)mapOrArgumentList).getNamedArguments().length > 0;
    }

    @Nullable
    private static PsiElement findMapOrArgumentList(CompletionParameters parameters) {
        PsiElement parent = parameters.getPosition().getParent();
        if (parent instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)parent).getQualifier() != null) {
                return null;
            }
            return parent.getParent();
        }
        if (parent == null || parent.getParent() == null) {
            return null;
        }
        return parent.getParent().getParent();
    }

    @NotNull
    private static Map<String, NamedArgumentDescriptor> findOtherNamedArgumentsInFile(PsiElement mapOrArgumentList) {
        final HashMap<String, NamedArgumentDescriptor> map2 = new HashMap<String, NamedArgumentDescriptor>();
        mapOrArgumentList.getContainingFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                String name;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof GrArgumentLabel && GroovyNamesUtil.isIdentifier(name = ((GrArgumentLabel)element).getName())) {
                    map2.put(name, NamedArgumentDescriptor.SIMPLE_UNLIKELY);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider$1", "visitElement"));
            }
        });
        HashMap<String, NamedArgumentDescriptor> hashMap = map2;
        if (hashMap == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private static GrNamedArgument[] getSiblingNamedArguments(PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList instanceof GrListOrMap) {
            return ((GrListOrMap)mapOrArgumentList).getNamedArguments();
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList && argumentList.getParent() instanceof GrCall) {
            return PsiUtil.getFirstMapNamedArguments((GrCall)argumentList.getParent());
        }
        return GrNamedArgument.EMPTY_ARRAY;
    }

    @NotNull
    private static Map<String, NamedArgumentDescriptor> calculateNamedArguments(@NotNull PsiElement mapOrArgumentList) {
        Map<String, NamedArgumentDescriptor> map2;
        if (mapOrArgumentList == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(4);
        }
        if (((map2 = MapArgumentCompletionProvider.calcNamedArgumentsForCall(mapOrArgumentList)) == null || map2.isEmpty()) && mapOrArgumentList instanceof GrListOrMap) {
            map2 = NamedArgumentUtilKt.getDescriptors((GrListOrMap)mapOrArgumentList);
        }
        if (map2 == null || map2.isEmpty()) {
            map2 = MapArgumentCompletionProvider.findOtherNamedArgumentsInFile(mapOrArgumentList);
        }
        Map<String, NamedArgumentDescriptor> map3 = map2;
        if (map3 == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(5);
        }
        return map3;
    }

    @Nullable
    private static Map<String, NamedArgumentDescriptor> calcNamedArgumentsForCall(@NotNull PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList) {
            if (mapOrArgumentList instanceof GrListOrMap && (((GrArgumentList)argumentList).getNamedArguments().length > 0 || ((GrArgumentList)argumentList).getExpressionArgumentIndex((GrListOrMap)mapOrArgumentList) > 0)) {
                return Collections.emptyMap();
            }
            if (argumentList.getParent() instanceof GrCall) {
                return GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders((GrCall)argumentList.getParent(), null, true);
            }
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapOrArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findOtherNamedArgumentsInFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateNamedArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateNamedArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcNamedArgumentsForCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

