/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import org.apache.lucene.document.SortedNumericDocValuesSetQuery;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.Query;

public class SortedNumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedNumericDocValuesField(String name, long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue);
    }

    public static Query newSlowSetQuery(String field, long ... values) {
        return new SortedNumericDocValuesSetQuery(field, (long[])values.clone());
    }

    public static Query newSlowExactQuery(String field, long value) {
        return SortedNumericDocValuesField.newSlowRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

