/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;

public abstract class SourceGraphNode<K, V>
extends GraphNode {
    private final Set<String> topicNames;
    private final Pattern topicPattern;
    private final ConsumedInternal<K, V> consumedInternal;

    public SourceGraphNode(String nodeName, Collection<String> topicNames, ConsumedInternal<K, V> consumedInternal) {
        super(nodeName);
        this.topicNames = new HashSet<String>(topicNames);
        this.topicPattern = null;
        this.consumedInternal = consumedInternal;
    }

    public SourceGraphNode(String nodeName, Pattern topicPattern, ConsumedInternal<K, V> consumedInternal) {
        super(nodeName);
        this.topicNames = null;
        this.topicPattern = topicPattern;
        this.consumedInternal = consumedInternal;
    }

    public Optional<Set<String>> topicNames() {
        return this.topicNames == null ? Optional.empty() : Optional.of(Collections.unmodifiableSet(this.topicNames));
    }

    public Optional<Pattern> topicPattern() {
        return Optional.ofNullable(this.topicPattern);
    }

    public ConsumedInternal<K, V> consumedInternal() {
        return this.consumedInternal;
    }

    public Serde<K> keySerde() {
        return this.consumedInternal.keySerde();
    }

    public Serde<V> valueSerde() {
        return this.consumedInternal.valueSerde();
    }
}

