/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate1_2_0_CR1
extends CustomKeycloakTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String realmClientTableName = this.database.correctObjectName("REALM_CLIENT", Table.class);
        try {
            String trueValue = DataTypeFactory.getInstance().getTrueBooleanValue(this.database);
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select CLIENT.REALM_ID, CLIENT.ID CLIENT_ID from " + this.getTableName("CLIENT") + " CLIENT where CLIENT.CONSENT_REQUIRED = " + trueValue);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String realmId = resultSet.getString("REALM_ID");
                    String oauthClientId = resultSet.getString("CLIENT_ID");
                    InsertStatement realmClientInsert = new InsertStatement(null, null, realmClientTableName).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("CLIENT_ID", (Object)oauthClientId);
                    this.statements.add(realmClientInsert);
                }
            }
            this.confirmationMessage.append("Inserted " + this.statements.size() + " OAuth Clients to REALM_CLIENT table");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Update 1.2.0.CR1";
    }
}

