/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.util.Arrays;

public class HKDFParameters
implements DerivationParameters {
    private final KeyParameter hkdfKey;
    private final byte[] info;

    public HKDFParameters(KeyParameter keyParameter, byte[] byArray) {
        if (keyParameter == null) {
            throw new IllegalArgumentException("hkdfKey (input keying material) should not be null");
        }
        this.hkdfKey = keyParameter;
        this.info = byArray == null ? new byte[0] : Arrays.clone(byArray);
    }

    public KeyParameter getKey() {
        return this.hkdfKey;
    }

    public byte[] getInfo() {
        return Arrays.clone(this.info);
    }
}

