/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.common.UUIDs;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.util.ParseUtils;

public class Feature
implements Writeable,
ToXContentObject {
    private static final String FEATURE_ID_FIELD = "feature_id";
    public static final String FEATURE_NAME_FIELD = "feature_name";
    private static final String FEATURE_ENABLED_FIELD = "feature_enabled";
    private static final String AGGREGATION_QUERY = "aggregation_query";
    private final String id;
    private final String name;
    private final Boolean enabled;
    private final AggregationBuilder aggregation;

    public Feature(String id, String name, Boolean enabled, AggregationBuilder aggregation) {
        if (Strings.isBlank((String)name)) {
            throw new IllegalArgumentException("Feature name should be set");
        }
        if (aggregation == null) {
            throw new IllegalArgumentException("Feature aggregation query should be set");
        }
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.aggregation = aggregation;
    }

    public Feature(StreamInput input) throws IOException {
        this.id = input.readString();
        this.name = input.readString();
        this.enabled = input.readBoolean();
        this.aggregation = (AggregationBuilder)input.readNamedWriteable(AggregationBuilder.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeBoolean(this.enabled.booleanValue());
        out.writeNamedWriteable((NamedWriteable)this.aggregation);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(FEATURE_ID_FIELD, this.id).field(FEATURE_NAME_FIELD, this.name).field(FEATURE_ENABLED_FIELD, this.enabled).field(AGGREGATION_QUERY).startObject().value((Object)this.aggregation).endObject();
        return xContentBuilder.endObject();
    }

    public static Feature parse(XContentParser parser) throws IOException {
        String id = UUIDs.base64UUID();
        String name = null;
        Boolean enabled = null;
        AggregationBuilder aggregation = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "feature_id": {
                    id = parser.text();
                    break;
                }
                case "feature_name": {
                    name = parser.text();
                    break;
                }
                case "feature_enabled": {
                    enabled = parser.booleanValue();
                    break;
                }
                case "aggregation_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    aggregation = ParseUtils.toAggregationBuilder(parser);
                    break;
                }
            }
        }
        return new Feature(id, name, enabled, aggregation);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equal((Object)this.getId(), (Object)feature.getId()) && Objects.equal((Object)this.getName(), (Object)feature.getName()) && Objects.equal((Object)this.getEnabled(), (Object)feature.getEnabled()) && Objects.equal((Object)this.getAggregation(), (Object)feature.getAggregation());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.enabled});
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public AggregationBuilder getAggregation() {
        return this.aggregation;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("enabled", (Object)this.enabled).append("aggregation", (Object)this.aggregation).toString();
    }
}

