/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.ContinuousMetadata;
import org.opensearch.indexmanagement.rollup.model.RollupStats;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0002EFBu\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016B\u0011\b\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0015\u0010\u0019J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\t\u00104\u001a\u00020\u0004H\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\u0004H\u00c6\u0003J\u0017\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\t\u00109\u001a\u00020\rH\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010;\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010=\u001a\u00020\u0014H\u00c6\u0003J\u007f\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00042\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u00c6\u0001J\u0013\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010B\u001a\u00020CH\u00d6\u0001J\t\u0010D\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006G"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "id", "", "seqNo", "", "primaryTerm", "rollupID", "afterKey", "", "", "lastUpdatedTime", "Ljava/time/Instant;", "continuous", "Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;", "status", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;", "failureReason", "stats", "Lorg/opensearch/indexmanagement/rollup/model/RollupStats;", "<init>", "(Ljava/lang/String;JJLjava/lang/String;Ljava/util/Map;Ljava/time/Instant;Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;Ljava/lang/String;Lorg/opensearch/indexmanagement/rollup/model/RollupStats;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getSeqNo", "()J", "getPrimaryTerm", "getRollupID", "getAfterKey", "()Ljava/util/Map;", "getLastUpdatedTime", "()Ljava/time/Instant;", "getContinuous", "()Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;", "getStatus", "()Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;", "getFailureReason", "getStats", "()Lorg/opensearch/indexmanagement/rollup/model/RollupStats;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "hashCode", "", "toString", "Status", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMetadata.kt\norg/opensearch/indexmanagement/rollup/model/RollupMetadata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class RollupMetadata
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final String rollupID;
    @Nullable
    private final Map<String, Object> afterKey;
    @NotNull
    private final Instant lastUpdatedTime;
    @Nullable
    private final ContinuousMetadata continuous;
    @NotNull
    private final Status status;
    @Nullable
    private final String failureReason;
    @NotNull
    private final RollupStats stats;
    @NotNull
    public static final String ROLLUP_METADATA_TYPE = "rollup_metadata";
    @NotNull
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    @NotNull
    public static final String AFTER_KEY_FIELD = "after_key";
    @NotNull
    public static final String LAST_UPDATED_FIELD = "last_updated_time";
    @NotNull
    public static final String LAST_UPDATED_FIELD_IN_MILLIS = "last_updated_time_in_millis";
    @NotNull
    public static final String CONTINUOUS_FIELD = "continuous";
    @NotNull
    public static final String STATUS_FIELD = "status";
    @NotNull
    public static final String FAILURE_REASON = "failure_reason";
    @NotNull
    public static final String STATS_FIELD = "stats";

    public RollupMetadata(@NotNull String id, long seqNo, long primaryTerm, @NotNull String rollupID, @Nullable Map<String, ? extends Object> afterKey, @NotNull Instant lastUpdatedTime, @Nullable ContinuousMetadata continuous, @NotNull Status status, @Nullable String failureReason, @NotNull RollupStats stats) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)rollupID, (String)"rollupID");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.rollupID = rollupID;
        this.afterKey = afterKey;
        this.lastUpdatedTime = lastUpdatedTime;
        this.continuous = continuous;
        this.status = status;
        this.failureReason = failureReason;
        this.stats = stats;
    }

    public /* synthetic */ RollupMetadata(String string, long l, long l2, String string2, Map map, Instant instant, ContinuousMetadata continuousMetadata, Status status, String string3, RollupStats rollupStats, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            l = -2L;
        }
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            map = null;
        }
        if ((n & 0x40) != 0) {
            continuousMetadata = null;
        }
        if ((n & 0x100) != 0) {
            string3 = null;
        }
        this(string, l, l2, string2, map, instant, continuousMetadata, status, string3, rollupStats);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final String getRollupID() {
        return this.rollupID;
    }

    @Nullable
    public final Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    @NotNull
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ContinuousMetadata getContinuous() {
        return this.continuous;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Nullable
    public final String getFailureReason() {
        return this.failureReason;
    }

    @NotNull
    public final RollupStats getStats() {
        return this.stats;
    }

    public RollupMetadata(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        long l = sin.readLong();
        long l2 = sin.readLong();
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        Map map = sin.readBoolean() ? sin.readMap() : null;
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        ContinuousMetadata continuousMetadata = sin.readBoolean() ? new ContinuousMetadata(sin) : null;
        Enum enum_ = sin.readEnum(Status.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        this(string, l, l2, string2, map, instant, continuousMetadata, (Status)enum_, sin.readOptionalString(), new RollupStats(sin));
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(ROLLUP_METADATA_TYPE);
        }
        builder.field(ROLLUP_ID_FIELD, this.rollupID);
        if (this.afterKey != null) {
            builder.field(AFTER_KEY_FIELD, this.afterKey);
        }
        builder.timeField(LAST_UPDATED_FIELD, LAST_UPDATED_FIELD_IN_MILLIS, this.lastUpdatedTime.toEpochMilli());
        if (this.continuous != null) {
            builder.field(CONTINUOUS_FIELD, (ToXContent)this.continuous);
        }
        builder.field(STATUS_FIELD, this.status.getType());
        builder.field(FAILURE_REASON, this.failureReason);
        builder.field(STATS_FIELD, (ToXContent)this.stats);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeString(this.rollupID);
        out.writeBoolean(this.afterKey != null);
        Map<String, Object> map = this.afterKey;
        if (map != null) {
            Map<String, Object> it = map;
            boolean bl = false;
            out.writeMap(it);
        }
        out.writeInstant(this.lastUpdatedTime);
        out.writeBoolean(this.continuous != null);
        ContinuousMetadata continuousMetadata = this.continuous;
        if (continuousMetadata != null) {
            continuousMetadata.writeTo(out);
        }
        out.writeEnum((Enum)this.status);
        out.writeOptionalString(this.failureReason);
        this.stats.writeTo(out);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    @NotNull
    public final String component4() {
        return this.rollupID;
    }

    @Nullable
    public final Map<String, Object> component5() {
        return this.afterKey;
    }

    @NotNull
    public final Instant component6() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ContinuousMetadata component7() {
        return this.continuous;
    }

    @NotNull
    public final Status component8() {
        return this.status;
    }

    @Nullable
    public final String component9() {
        return this.failureReason;
    }

    @NotNull
    public final RollupStats component10() {
        return this.stats;
    }

    @NotNull
    public final RollupMetadata copy(@NotNull String id, long seqNo, long primaryTerm, @NotNull String rollupID, @Nullable Map<String, ? extends Object> afterKey, @NotNull Instant lastUpdatedTime, @Nullable ContinuousMetadata continuous, @NotNull Status status, @Nullable String failureReason, @NotNull RollupStats stats) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)rollupID, (String)"rollupID");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        return new RollupMetadata(id, seqNo, primaryTerm, rollupID, afterKey, lastUpdatedTime, continuous, status, failureReason, stats);
    }

    public static /* synthetic */ RollupMetadata copy$default(RollupMetadata rollupMetadata, String string, long l, long l2, String string2, Map map, Instant instant, ContinuousMetadata continuousMetadata, Status status, String string3, RollupStats rollupStats, int n, Object object) {
        if ((n & 1) != 0) {
            string = rollupMetadata.id;
        }
        if ((n & 2) != 0) {
            l = rollupMetadata.seqNo;
        }
        if ((n & 4) != 0) {
            l2 = rollupMetadata.primaryTerm;
        }
        if ((n & 8) != 0) {
            string2 = rollupMetadata.rollupID;
        }
        if ((n & 0x10) != 0) {
            map = rollupMetadata.afterKey;
        }
        if ((n & 0x20) != 0) {
            instant = rollupMetadata.lastUpdatedTime;
        }
        if ((n & 0x40) != 0) {
            continuousMetadata = rollupMetadata.continuous;
        }
        if ((n & 0x80) != 0) {
            status = rollupMetadata.status;
        }
        if ((n & 0x100) != 0) {
            string3 = rollupMetadata.failureReason;
        }
        if ((n & 0x200) != 0) {
            rollupStats = rollupMetadata.stats;
        }
        return rollupMetadata.copy(string, l, l2, string2, map, instant, continuousMetadata, status, string3, rollupStats);
    }

    @NotNull
    public String toString() {
        return "RollupMetadata(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", rollupID=" + this.rollupID + ", afterKey=" + this.afterKey + ", lastUpdatedTime=" + this.lastUpdatedTime + ", continuous=" + this.continuous + ", status=" + this.status + ", failureReason=" + this.failureReason + ", stats=" + this.stats + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + this.rollupID.hashCode();
        result2 = result2 * 31 + (this.afterKey == null ? 0 : ((Object)this.afterKey).hashCode());
        result2 = result2 * 31 + this.lastUpdatedTime.hashCode();
        result2 = result2 * 31 + (this.continuous == null ? 0 : this.continuous.hashCode());
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.failureReason == null ? 0 : this.failureReason.hashCode());
        result2 = result2 * 31 + this.stats.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RollupMetadata)) {
            return false;
        }
        RollupMetadata rollupMetadata = (RollupMetadata)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)rollupMetadata.id)) {
            return false;
        }
        if (this.seqNo != rollupMetadata.seqNo) {
            return false;
        }
        if (this.primaryTerm != rollupMetadata.primaryTerm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rollupID, (Object)rollupMetadata.rollupID)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.afterKey, rollupMetadata.afterKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)rollupMetadata.lastUpdatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.continuous, (Object)rollupMetadata.continuous)) {
            return false;
        }
        if (this.status != rollupMetadata.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failureReason, (Object)rollupMetadata.failureReason)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stats, (Object)rollupMetadata.stats);
    }

    @JvmStatic
    @NotNull
    public static final RollupMetadata parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id, seqNo, primaryTerm);
    }

    @JvmStatic
    @NotNull
    public static final RollupMetadata readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Companion;", "", "<init>", "()V", "ROLLUP_METADATA_TYPE", "", "ROLLUP_ID_FIELD", "AFTER_KEY_FIELD", "LAST_UPDATED_FIELD", "LAST_UPDATED_FIELD_IN_MILLIS", "CONTINUOUS_FIELD", "STATUS_FIELD", "FAILURE_REASON", "STATS_FIELD", "parse", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nRollupMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMetadata.kt\norg/opensearch/indexmanagement/rollup/model/RollupMetadata$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RollupMetadata parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String rollupID = null;
            Map afterKey = null;
            Instant lastUpdatedTime = null;
            ContinuousMetadata continuous = null;
            Status status = null;
            String failureReason = null;
            RollupStats stats = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case -1670470950: {
                        if (string.equals(RollupMetadata.LAST_UPDATED_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 109757599: {
                        if (string.equals(RollupMetadata.STATS_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 379114255: {
                        if (string.equals(RollupMetadata.CONTINUOUS_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1019577724: {
                        if (string.equals(RollupMetadata.AFTER_KEY_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 1743941273: {
                        if (string.equals(RollupMetadata.FAILURE_REASON)) {
                            n = 5;
                        }
                        break;
                    }
                    case 556621538: {
                        if (string.equals(RollupMetadata.ROLLUP_ID_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case -892481550: {
                        if (string.equals(RollupMetadata.STATUS_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        rollupID = xcp.text();
                        break;
                    }
                    case 4: {
                        afterKey = xcp.map();
                        break;
                    }
                    case 1: {
                        lastUpdatedTime = OpenSearchExtensionsKt.instant(xcp);
                        break;
                    }
                    case 3: {
                        continuous = ContinuousMetadata.Companion.parse(xcp);
                        break;
                    }
                    case 7: {
                        String string2;
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                        String string3 = string2.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                        status = Status.valueOf(string3);
                        break;
                    }
                    case 5: {
                        failureReason = xcp.textOrNull();
                        break;
                    }
                    case 2: {
                        stats = RollupStats.Companion.parse(xcp);
                    }
                }
            }
            String string = id;
            long l = seqNo;
            long l2 = primaryTerm;
            String string4 = rollupID;
            if (string4 == null) {
                long l3 = l2;
                long l4 = l;
                String string5 = string;
                boolean $i$a$-requireNotNull-RollupMetadata$Companion$parse$52 = false;
                String string6 = "RollupID must not be null";
                String string7 = string5;
                long l5 = l4;
                long l6 = l3;
                String $i$a$-requireNotNull-RollupMetadata$Companion$parse$52 = string6;
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetadata$Companion$parse$52.toString());
            }
            Map map = afterKey;
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                Map map2 = map;
                String string8 = string4;
                long l7 = l2;
                long l8 = l;
                String string9 = string;
                boolean $i$a$-requireNotNull-RollupMetadata$Companion$parse$62 = false;
                String string10 = "Last updated time must not be null";
                String string11 = string9;
                long l9 = l8;
                long l10 = l7;
                String string12 = string8;
                Map map3 = map2;
                String $i$a$-requireNotNull-RollupMetadata$Companion$parse$62 = string10;
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetadata$Companion$parse$62.toString());
            }
            ContinuousMetadata continuousMetadata = continuous;
            Status status2 = status;
            if (status2 == null) {
                ContinuousMetadata continuousMetadata2 = continuousMetadata;
                Instant instant2 = instant;
                Map map4 = map;
                String string13 = string4;
                long l11 = l2;
                long l12 = l;
                String string14 = string;
                boolean $i$a$-requireNotNull-RollupMetadata$Companion$parse$72 = false;
                String string15 = "Status must not be null";
                String string16 = string14;
                long l13 = l12;
                long l14 = l11;
                String string17 = string13;
                Map map5 = map4;
                Instant instant3 = instant2;
                ContinuousMetadata continuousMetadata3 = continuousMetadata2;
                String $i$a$-requireNotNull-RollupMetadata$Companion$parse$72 = string15;
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetadata$Companion$parse$72.toString());
            }
            String string18 = failureReason;
            RollupStats rollupStats = stats;
            if (rollupStats == null) {
                String string19 = string18;
                Status status3 = status2;
                ContinuousMetadata continuousMetadata4 = continuousMetadata;
                Instant instant4 = instant;
                Map map6 = map;
                String string20 = string4;
                long l15 = l2;
                long l16 = l;
                String string21 = string;
                boolean bl = false;
                String string22 = "Stats must not be null";
                String string23 = string21;
                long l17 = l16;
                long l18 = l15;
                String string24 = string20;
                Map map7 = map6;
                Instant instant5 = instant4;
                ContinuousMetadata continuousMetadata5 = continuousMetadata4;
                Status status4 = status3;
                String string25 = string19;
                String string26 = string22;
                throw new IllegalArgumentException(string26.toString());
            }
            RollupStats rollupStats2 = rollupStats;
            String string27 = string18;
            Status status5 = status2;
            ContinuousMetadata continuousMetadata6 = continuousMetadata;
            Instant instant6 = instant;
            Map map8 = map;
            String string28 = string4;
            long l19 = l2;
            long l20 = l;
            String string29 = string;
            return new RollupMetadata(string29, l20, l19, string28, map8, instant6, continuousMetadata6, status5, string27, rollupStats2);
        }

        public static /* synthetic */ RollupMetadata parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @NotNull
        public final RollupMetadata readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new RollupMetadata(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;", "", "type", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "INIT", "STARTED", "STOPPED", "FINISHED", "FAILED", "RETRY", "toString", "opensearch-index-management"})
    public static final class Status
    extends Enum<Status> {
        @NotNull
        private final String type;
        public static final /* enum */ Status INIT = new Status("init");
        public static final /* enum */ Status STARTED = new Status("started");
        public static final /* enum */ Status STOPPED = new Status("stopped");
        public static final /* enum */ Status FINISHED = new Status("finished");
        public static final /* enum */ Status FAILED = new Status("failed");
        public static final /* enum */ Status RETRY = new Status("retry");
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Status(String type) {
            this.type = type;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return this.type;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.INIT, Status.STARTED, Status.STOPPED, Status.FINISHED, Status.FAILED, Status.RETRY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

