/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.multipdf;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PageExtractor {
    private final PDDocument sourceDocument;
    private int startPage = 1;
    private int endPage;

    public PageExtractor(PDDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
        this.endPage = sourceDocument.getNumberOfPages();
    }

    public PageExtractor(PDDocument sourceDocument, int startPage, int endPage) {
        this.sourceDocument = sourceDocument;
        this.startPage = startPage;
        this.endPage = endPage;
    }

    public PDDocument extract() throws IOException {
        if (this.endPage - this.startPage + 1 <= 0) {
            return new PDDocument();
        }
        Splitter splitter = new Splitter();
        splitter.setStartPage(Math.max(this.startPage, 1));
        splitter.setEndPage(Math.min(this.endPage, this.sourceDocument.getNumberOfPages()));
        splitter.setSplitAtPage(this.getEndPage() - this.getStartPage() + 1);
        List<PDDocument> splitted = splitter.split(this.sourceDocument);
        return splitted.get(0);
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }
}

