/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DruidTableModel
implements TableModel {
    private ArrayList<LinkedHashMap<String, Object>> list;
    private ArrayList<String> showKeys;

    public DruidTableModel(ArrayList<LinkedHashMap<String, Object>> list) {
        this.list = list;
        this.showKeys = null;
    }

    public DruidTableModel(ArrayList<LinkedHashMap<String, Object>> list, ArrayList<String> showKeys) {
        this.list = list;
        this.showKeys = showKeys;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        int listLen;
        int colCount = 0;
        if (this.showKeys != null) {
            colCount = this.showKeys.size();
        } else if (this.list != null && (listLen = this.list.size()) > 0) {
            colCount = this.list.get(0).size();
        }
        return colCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String keyNow;
        if (this.showKeys != null && this.showKeys.size() > 0 && (keyNow = this.showKeys.get(columnIndex)) != null) {
            return keyNow.substring(keyNow.indexOf(45) + 1, keyNow.length());
        }
        if (this.list != null && this.list.size() > 0) {
            LinkedHashMap<String, Object> firstElement = this.list.get(0);
            Object[] keys2 = firstElement.keySet().toArray();
            return keys2[columnIndex].toString();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.list != null && rowIndex < this.list.size()) {
            LinkedHashMap<String, Object> dataNow = this.list.get(rowIndex);
            if (this.showKeys != null) {
                int titleLen = this.showKeys.size();
                if (titleLen > 0 && columnIndex < titleLen) {
                    return dataNow.get(this.showKeys.get(columnIndex));
                }
            } else {
                Object[] values2 = dataNow.values().toArray();
                if (columnIndex < values2.length) {
                    return values2[columnIndex];
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

