/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;

public class NoLoggingImpl
implements Log {
    private int infoCount;
    private int errorCount;
    private int warnCount;
    private int debugCount;
    private String loggerName;

    public NoLoggingImpl(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void error(String s2, Throwable e) {
        this.error(s2);
        if (e != null) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(String s2) {
        ++this.errorCount;
        if (s2 != null) {
            System.err.println(this.loggerName + " : " + s2);
        }
    }

    @Override
    public void debug(String s2) {
        ++this.debugCount;
    }

    @Override
    public void debug(String s2, Throwable e) {
        ++this.debugCount;
    }

    @Override
    public void warn(String s2) {
        ++this.warnCount;
    }

    @Override
    public void warn(String s2, Throwable e) {
        ++this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public void info(String s2) {
        ++this.infoCount;
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }
}

