/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.StepCancellationOption;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CancelStepsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterId;
    private SdkInternalList<String> stepIds;
    private String stepCancellationOption;

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public CancelStepsRequest withClusterId(String clusterId) {
        this.setClusterId(clusterId);
        return this;
    }

    public List<String> getStepIds() {
        if (this.stepIds == null) {
            this.stepIds = new SdkInternalList();
        }
        return this.stepIds;
    }

    public void setStepIds(Collection<String> stepIds) {
        if (stepIds == null) {
            this.stepIds = null;
            return;
        }
        this.stepIds = new SdkInternalList<String>(stepIds);
    }

    public CancelStepsRequest withStepIds(String ... stepIds) {
        if (this.stepIds == null) {
            this.setStepIds(new SdkInternalList<String>(stepIds.length));
        }
        for (String ele : stepIds) {
            this.stepIds.add(ele);
        }
        return this;
    }

    public CancelStepsRequest withStepIds(Collection<String> stepIds) {
        this.setStepIds(stepIds);
        return this;
    }

    public void setStepCancellationOption(String stepCancellationOption) {
        this.stepCancellationOption = stepCancellationOption;
    }

    public String getStepCancellationOption() {
        return this.stepCancellationOption;
    }

    public CancelStepsRequest withStepCancellationOption(String stepCancellationOption) {
        this.setStepCancellationOption(stepCancellationOption);
        return this;
    }

    public CancelStepsRequest withStepCancellationOption(StepCancellationOption stepCancellationOption) {
        this.stepCancellationOption = stepCancellationOption.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterId() != null) {
            sb.append("ClusterId: ").append(this.getClusterId()).append(",");
        }
        if (this.getStepIds() != null) {
            sb.append("StepIds: ").append(this.getStepIds()).append(",");
        }
        if (this.getStepCancellationOption() != null) {
            sb.append("StepCancellationOption: ").append(this.getStepCancellationOption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest)obj;
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getStepIds() == null ^ this.getStepIds() == null) {
            return false;
        }
        if (other.getStepIds() != null && !other.getStepIds().equals(this.getStepIds())) {
            return false;
        }
        if (other.getStepCancellationOption() == null ^ this.getStepCancellationOption() == null) {
            return false;
        }
        return other.getStepCancellationOption() == null || other.getStepCancellationOption().equals(this.getStepCancellationOption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getStepIds() == null ? 0 : this.getStepIds().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getStepCancellationOption() == null ? 0 : this.getStepCancellationOption().hashCode());
        return hashCode2;
    }

    @Override
    public CancelStepsRequest clone() {
        return (CancelStepsRequest)super.clone();
    }
}

