/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.util;

import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamingStep {
    private List<String> inputs = new ArrayList<String>();
    private String output;
    private String mapper;
    private String reducer;
    private Map<String, String> hadoopConfig = new HashMap<String, String>();

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        ArrayList<String> newInputs = new ArrayList<String>();
        if (inputs != null) {
            newInputs.addAll(inputs);
        }
        this.inputs = newInputs;
    }

    public StreamingStep withInputs(String ... inputs) {
        for (String input : inputs) {
            this.inputs.add(input);
        }
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public StreamingStep withOutput(String output) {
        this.output = output;
        return this;
    }

    public String getMapper() {
        return this.mapper;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public StreamingStep withMapper(String mapper) {
        this.mapper = mapper;
        return this;
    }

    public String getReducer() {
        return this.reducer;
    }

    public void setReducer(String reducer) {
        this.reducer = reducer;
    }

    public StreamingStep withReducer(String reducer) {
        this.reducer = reducer;
        return this;
    }

    public Map<String, String> getHadoopConfig() {
        return this.hadoopConfig;
    }

    public void setHadoopConfig(Map<String, String> hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
    }

    public StreamingStep withHadoopConfig(String key, String value) {
        this.hadoopConfig.put(key, value);
        return this;
    }

    public HadoopJarStepConfig toHadoopJarStepConfig() {
        ArrayList<String> args2 = new ArrayList<String>();
        if (this.reducer == null) {
            this.hadoopConfig.put("mapred.reduce.tasks", "0");
        }
        for (Map.Entry<String, String> entry : this.hadoopConfig.entrySet()) {
            args2.add("-D");
            args2.add(entry.getKey() + "=" + entry.getValue());
        }
        for (String input : this.inputs) {
            args2.add("-input");
            args2.add(input);
        }
        if (this.output != null) {
            args2.add("-output");
            args2.add(this.output);
        }
        if (this.mapper != null) {
            args2.add("-mapper");
            args2.add(this.mapper);
        }
        if (this.reducer != null) {
            args2.add("-reducer");
            args2.add(this.reducer);
        }
        return new HadoopJarStepConfig().withJar("/home/hadoop/contrib/streaming/hadoop-streaming.jar").withArgs(args2);
    }
}

