/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import shaded.com.google.common.base.Preconditions;

public class MathUtils {
    private MathUtils() {
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int oldB = b;
            b = a % b;
            a = oldB;
        }
        return Math.abs(a);
    }

    public static byte[] nonNegativeLongToBigEndianBytes(int byteCount, long value) {
        Preconditions.checkArgument(value >= 0L, "Negative numbers are not allowed.");
        byte[] bytes = new byte[byteCount];
        int i = byteCount - 1;
        while (value != 0L) {
            bytes[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        return bytes;
    }

    public static long unsignedBigEndianBytesToNonNegativeLong(byte[] bytes) {
        Preconditions.checkArgument(bytes.length < 8 || bytes.length == 8 & bytes[0] >= 0);
        int value = 0;
        for (int i = 0; i < bytes.length; ++i) {
            value <<= 8;
            value |= bytes[i] & 0xFF;
        }
        assert (value >= 0);
        return value;
    }

    public static int bitCountToByteCount(int bitCount) {
        return bitCount + 7 >>> 3;
    }

    public static byte[] doubleToBytes(double value) {
        long asLong = Double.doubleToLongBits(value);
        return new byte[]{(byte)(asLong >>> 56 & 0xFFL), (byte)(asLong >>> 48 & 0xFFL), (byte)(asLong >>> 40 & 0xFFL), (byte)(asLong >>> 32 & 0xFFL), (byte)(asLong >>> 24 & 0xFFL), (byte)(asLong >>> 16 & 0xFFL), (byte)(asLong >>> 8 & 0xFFL), (byte)(asLong >>> 0 & 0xFFL)};
    }

    public static double bytesToDouble(byte[] bytes) {
        Preconditions.checkState(bytes.length == 8);
        long asLong = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[7] & 0xFFL) << 0;
        return Double.longBitsToDouble(asLong);
    }

    public static int numberOfLeadingZeros(byte b) {
        return Integer.numberOfLeadingZeros(b & 0xFF) - 24;
    }
}

