/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableMap;

public class RelRecordType
extends RelDataTypeImpl
implements Serializable {
    private final StructKind kind;
    private final boolean nullable;
    private final @Nullable Map<String, RelDataTypeField> fieldNameMap;
    private static final int THRESHOLD = 20;

    public RelRecordType(StructKind kind, List<RelDataTypeField> fields2, boolean nullable) {
        super(fields2);
        this.nullable = nullable;
        this.kind = Objects.requireNonNull(kind, "kind");
        if (fields2.size() > 20) {
            HashMap<String, RelDataTypeField> map = new HashMap<String, RelDataTypeField>();
            for (RelDataTypeField f : fields2) {
                map.putIfAbsent(f.getName(), f);
                if (!f.isDynamicStar()) continue;
                map.putIfAbsent("", f);
            }
            this.fieldNameMap = ImmutableMap.copyOf(map);
        } else {
            this.fieldNameMap = null;
        }
        this.computeDigest();
    }

    public RelRecordType(StructKind kind, List<RelDataTypeField> fields2) {
        this(kind, fields2, false);
    }

    public RelRecordType(List<RelDataTypeField> fields2) {
        this(StructKind.FULLY_QUALIFIED, fields2, false);
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.ROW;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public StructKind getStructKind() {
        return this.kind;
    }

    @Override
    protected @Nullable Map<String, RelDataTypeField> getFieldMap() {
        return this.fieldNameMap;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("RecordType");
        switch (this.kind) {
            case PEEK_FIELDS: {
                sb.append(":peek");
                break;
            }
            case PEEK_FIELDS_DEFAULT: {
                sb.append(":peek_default");
                break;
            }
            case PEEK_FIELDS_NO_EXPAND: {
                sb.append(":peek_no_expand");
                break;
            }
        }
        sb.append("(");
        for (Ord ord : Ord.zip(Objects.requireNonNull(this.fieldList, "fieldList"))) {
            if (ord.i > 0) {
                sb.append(", ");
            }
            RelDataTypeField field = (RelDataTypeField)ord.e;
            if (withDetail) {
                sb.append(field.getType().getFullTypeString());
            } else {
                sb.append(field.getType().toString());
            }
            sb.append(" ");
            sb.append(field.getName());
        }
        sb.append(")");
    }

    private Object writeReplace() {
        return new SerializableRelRecordType(Objects.requireNonNull(this.fieldList, "fieldList"));
    }

    private static class SerializableRelRecordType
    implements Serializable {
        private final List<RelDataTypeField> fields;

        private SerializableRelRecordType(List<RelDataTypeField> fields2) {
            this.fields = Objects.requireNonNull(fields2, "fields");
        }

        private Object readResolve() {
            return new RelRecordType(this.fields);
        }
    }
}

