/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import shaded.com.google.common.collect.ImmutableCollection;
import shaded.com.google.common.collect.ImmutableList;

public class SqlIdentifier
extends SqlNode {
    public static final SqlIdentifier STAR = SqlIdentifier.star(SqlParserPos.ZERO);
    public ImmutableList<String> names;
    final @Nullable SqlCollation collation;
    protected @Nullable ImmutableList<SqlParserPos> componentPositions;

    public SqlIdentifier(List<String> names, @Nullable SqlCollation collation, SqlParserPos pos, @Nullable List<SqlParserPos> componentPositions) {
        super(pos);
        this.names = ImmutableList.copyOf(names);
        this.collation = collation;
        this.componentPositions = componentPositions == null ? null : ImmutableList.copyOf(componentPositions);
    }

    public SqlIdentifier(List<String> names, SqlParserPos pos) {
        this(names, null, pos, null);
    }

    public SqlIdentifier(String name, @Nullable SqlCollation collation, SqlParserPos pos) {
        this(ImmutableList.of(name), collation, pos, null);
    }

    public SqlIdentifier(String name, SqlParserPos pos) {
        this(ImmutableList.of(name), null, pos, null);
    }

    public static SqlIdentifier star(SqlParserPos pos) {
        return SqlIdentifier.star(ImmutableList.of(""), pos, ImmutableList.of(pos));
    }

    public static SqlIdentifier star(List<String> names, SqlParserPos pos, List<SqlParserPos> componentPositions) {
        return new SqlIdentifier(Util.transform(names, s2 -> s2.equals("*") ? "" : s2), null, pos, componentPositions);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.IDENTIFIER;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlIdentifier(this.names, this.collation, pos, this.componentPositions);
    }

    @Override
    public String toString() {
        return SqlIdentifier.getString(this.names);
    }

    public static String getString(List<String> names) {
        return Util.sepList(SqlIdentifier.toStar(names), ".");
    }

    public static List<String> toStar(List<String> names) {
        return Util.transform(names, s2 -> s2.equals("") ? "*" : s2);
    }

    public void setNames(List<String> names, @Nullable List<SqlParserPos> poses) {
        this.names = ImmutableList.copyOf(names);
        this.componentPositions = poses == null ? null : ImmutableList.copyOf(poses);
    }

    public SqlIdentifier setName(int i, String name) {
        if (!((String)this.names.get(i)).equals(name)) {
            String[] nameArray = this.names.toArray(new String[0]);
            nameArray[i] = name;
            return new SqlIdentifier(ImmutableList.copyOf(nameArray), this.collation, this.pos, this.componentPositions);
        }
        return this;
    }

    public SqlIdentifier add(int i, String name, SqlParserPos pos) {
        ArrayList<SqlParserPos> pos2;
        ArrayList<String> names2 = new ArrayList<String>(this.names);
        names2.add(i, name);
        if (this.componentPositions == null) {
            pos2 = null;
        } else {
            pos2 = new ArrayList<SqlParserPos>(this.componentPositions);
            pos2.add(i, pos);
        }
        return new SqlIdentifier(names2, this.collation, pos, pos2);
    }

    public SqlParserPos getComponentParserPosition(int i) {
        assert (i >= 0 && i < this.names.size());
        return this.componentPositions == null ? this.getParserPosition() : (SqlParserPos)this.componentPositions.get(i);
    }

    public void assignNamesFrom(SqlIdentifier other) {
        this.setNames(other.names, other.componentPositions);
    }

    public SqlIdentifier getComponent(int ordinal) {
        return this.getComponent(ordinal, ordinal + 1);
    }

    public SqlIdentifier getComponent(int from, int to) {
        SqlParserPos pos;
        List pos2;
        if (this.componentPositions == null) {
            pos2 = null;
            pos = this.pos;
        } else {
            pos2 = this.componentPositions.subList(from, to);
            pos = SqlParserPos.sum(pos2);
        }
        return new SqlIdentifier(this.names.subList(from, to), this.collation, pos, pos2);
    }

    public SqlIdentifier plus(String name, SqlParserPos pos) {
        SqlParserPos pos2;
        ImmutableCollection componentPositions;
        ImmutableCollection names = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.names)).add(name)).build();
        ImmutableList<SqlParserPos> thisComponentPositions = this.componentPositions;
        if (thisComponentPositions != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            componentPositions = ((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(thisComponentPositions)).add(pos)).build();
            pos2 = SqlParserPos.sum(((ImmutableList.Builder)builder.add(this.pos)).build());
        } else {
            componentPositions = null;
            pos2 = pos;
        }
        return new SqlIdentifier((List<String>)((Object)names), this.collation, pos2, (List<SqlParserPos>)((Object)componentPositions));
    }

    public SqlIdentifier plusStar() {
        SqlIdentifier id = this.plus("*", SqlParserPos.ZERO);
        return new SqlIdentifier(id.names.stream().map(s2 -> s2.equals("*") ? "" : s2).collect(ImmutableList.toImmutableList()), null, id.pos, id.componentPositions);
    }

    public SqlIdentifier skipLast(int n) {
        return this.getComponent(0, this.names.size() - n);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlUtil.unparseSqlIdentifierSyntax(writer, this, false);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope2) {
        validator.validateIdentifier(this, scope2);
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope2) {
        SqlCall call = validator.makeNullaryCall(this);
        if (call != null) {
            validator.validateCall(call, scope2);
            return;
        }
        validator.validateIdentifier(this, scope2);
    }

    @Override
    public boolean equalsDeep(@Nullable SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlIdentifier)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlIdentifier that = (SqlIdentifier)node;
        if (this.names.size() != that.names.size()) {
            return litmus.fail("{} != {}", this, node);
        }
        for (int i = 0; i < this.names.size(); ++i) {
            if (((String)this.names.get(i)).equals(that.names.get(i))) continue;
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Pure
    public @Nullable SqlCollation getCollation() {
        return this.collation;
    }

    public String getSimple() {
        assert (this.names.size() == 1);
        return (String)this.names.get(0);
    }

    public static List<String> simpleNames(List<? extends SqlNode> list) {
        return Util.transform(list, n -> ((SqlIdentifier)n).getSimple());
    }

    public static Iterable<String> simpleNames(Iterable<? extends SqlNode> list) {
        return Util.transform(list, n -> ((SqlIdentifier)n).getSimple());
    }

    public boolean isStar() {
        return Util.last(this.names).equals("");
    }

    public boolean isSimple() {
        return this.names.size() == 1 && !this.isStar();
    }

    public boolean isComponentQuoted(int i) {
        return this.componentPositions != null && ((SqlParserPos)this.componentPositions.get(i)).isQuoted();
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope2) {
        if (Util.last(this.names).isEmpty() || DynamicRecordType.isDynamicStarColName(Util.last(this.names))) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        SqlValidator validator = scope2.getValidator();
        SqlCall call = validator.makeNullaryCall(this);
        if (call != null) {
            return call.getMonotonicity(scope2);
        }
        SqlQualified qualified = scope2.fullyQualify(this);
        if (qualified.namespace == null) {
            throw new IllegalArgumentException("namespace must not be null in " + qualified);
        }
        SqlIdentifier fqId = qualified.identifier;
        return qualified.namespace.resolve().getMonotonicity(Util.last(fqId.names));
    }
}

