/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

public enum SqlJdbcDataTypeName implements Symbolizable
{
    SQL_CHAR(SqlTypeName.CHAR),
    SQL_VARCHAR(SqlTypeName.VARCHAR),
    SQL_DATE(SqlTypeName.DATE),
    SQL_TIME(SqlTypeName.TIME),
    SQL_TIME_WITH_LOCAL_TIME_ZONE(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE),
    SQL_TIME_WITH_TIME_ZONE(SqlTypeName.TIME_TZ),
    SQL_TIMESTAMP(SqlTypeName.TIMESTAMP),
    SQL_TIMESTAMP_WITH_LOCAL_TIME_ZONE(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE),
    SQL_TIMESTAMP_WITH_TIME_ZONE(SqlTypeName.TIMESTAMP_TZ),
    SQL_DECIMAL(SqlTypeName.DECIMAL),
    SQL_NUMERIC(SqlTypeName.DECIMAL),
    SQL_BOOLEAN(SqlTypeName.BOOLEAN),
    SQL_INTEGER(SqlTypeName.INTEGER),
    SQL_BINARY(SqlTypeName.BINARY),
    SQL_VARBINARY(SqlTypeName.VARBINARY),
    SQL_TINYINT(SqlTypeName.TINYINT),
    SQL_SMALLINT(SqlTypeName.SMALLINT),
    SQL_BIGINT(SqlTypeName.BIGINT),
    SQL_REAL(SqlTypeName.REAL),
    SQL_DOUBLE(SqlTypeName.DOUBLE),
    SQL_FLOAT(SqlTypeName.FLOAT),
    SQL_INTERVAL_YEAR(TimeUnitRange.YEAR),
    SQL_INTERVAL_YEAR_TO_MONTH(TimeUnitRange.YEAR_TO_MONTH),
    SQL_INTERVAL_MONTH(TimeUnitRange.MONTH),
    SQL_INTERVAL_DAY(TimeUnitRange.DAY),
    SQL_INTERVAL_DAY_TO_HOUR(TimeUnitRange.DAY_TO_HOUR),
    SQL_INTERVAL_DAY_TO_MINUTE(TimeUnitRange.DAY_TO_MINUTE),
    SQL_INTERVAL_DAY_TO_SECOND(TimeUnitRange.DAY_TO_SECOND),
    SQL_INTERVAL_HOUR(TimeUnitRange.HOUR),
    SQL_INTERVAL_HOUR_TO_MINUTE(TimeUnitRange.HOUR_TO_MINUTE),
    SQL_INTERVAL_HOUR_TO_SECOND(TimeUnitRange.HOUR_TO_SECOND),
    SQL_INTERVAL_MINUTE(TimeUnitRange.MINUTE),
    SQL_INTERVAL_MINUTE_TO_SECOND(TimeUnitRange.MINUTE_TO_SECOND),
    SQL_INTERVAL_SECOND(TimeUnitRange.SECOND);

    private final @Nullable TimeUnitRange range;
    private final @Nullable SqlTypeName typeName;

    private SqlJdbcDataTypeName(SqlTypeName typeName) {
        this(typeName, null);
    }

    private SqlJdbcDataTypeName(TimeUnitRange range) {
        this(null, range);
    }

    private SqlJdbcDataTypeName(SqlTypeName typeName, TimeUnitRange range) {
        this.typeName = typeName;
        this.range = range;
        Preconditions.checkArgument(typeName == null != (range == null));
    }

    public SqlNode createDataType(SqlParserPos pos) {
        if (this.typeName != null) {
            Preconditions.checkArgument(this.range == null);
            return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(this.typeName, pos), pos);
        }
        Objects.requireNonNull(this.range, "range");
        return new SqlIntervalQualifier(this.range.startUnit, this.range.endUnit, pos);
    }
}

