/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.runtime.ConsList;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public abstract class ReflectiveSqlOperatorTable
extends SqlOperatorTables.IndexedSqlOperatorTable
implements SqlOperatorTable {
    public static final String IS_NAME = "INFORMATION_SCHEMA";

    protected ReflectiveSqlOperatorTable() {
        super(ImmutableList.of());
    }

    public final SqlOperatorTable init() {
        ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
        for (Field field : this.getClass().getFields()) {
            try {
                LibraryOperator libraryOperator;
                Object o = field.get(this);
                if (!(o instanceof SqlOperator) || (libraryOperator = field.getAnnotation(LibraryOperator.class)) != null && Arrays.stream(libraryOperator.libraries()).noneMatch(library -> library == SqlLibrary.STANDARD)) continue;
                list.add((SqlOperator)o);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Util.throwAsRuntime(Util.causeOrSelf(e));
            }
        }
        this.setOperators(ReflectiveSqlOperatorTable.buildIndex(list));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, @Nullable SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        String simpleName2;
        if (opName.names.size() > 1) {
            if (!((String)opName.names.get(opName.names.size() - 2)).equals(IS_NAME)) return;
            simpleName2 = Util.last(opName.names);
        } else {
            simpleName2 = opName.getSimple();
        }
        this.lookUpOperators(simpleName2, nameMatcher.isCaseSensitive(), op -> {
            if (op.getSyntax() == syntax) {
                operatorList.add((SqlOperator)op);
            } else if (syntax == SqlSyntax.FUNCTION && op instanceof SqlFunction) {
                operatorList.add((SqlOperator)op);
            }
        });
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                this.lookUpOperators(simpleName2, nameMatcher.isCaseSensitive(), extra -> {
                    if (extra != null && !operatorList.contains(extra)) {
                        operatorList.add((SqlOperator)extra);
                    }
                });
                return;
            }
        }
    }

    @Deprecated
    public void register(SqlOperator op) {
        this.setOperators(ReflectiveSqlOperatorTable.buildIndex(ConsList.of(op, this.getOperatorList())));
    }
}

