/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class LandsatProjection
extends Projection {
    private double a2;
    private double a4;
    private double b;
    private double c1;
    private double c3;
    private double q;
    private double t;
    private double u;
    private double w;
    private double p22;
    private double sa;
    private double ca;
    private double xj;
    private double rlm;
    private double rlm2;
    private static final double TOL = 1.0E-7;
    private static final double PI_HALFPI = 4.71238898038469;
    private static final double TWOPI_HALFPI = 7.853981633974483;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        int l;
        double lamt = 0.0;
        double lamdp = 0.0;
        if (lpphi > 1.5707963267948966) {
            lpphi = 1.5707963267948966;
        } else if (lpphi < -1.5707963267948966) {
            lpphi = -1.5707963267948966;
        }
        double lampp = lpphi >= 0.0 ? 1.5707963267948966 : 4.71238898038469;
        double tanphi = Math.tan(lpphi);
        int nn = 0;
        while (true) {
            double sav = lampp;
            double lamtp = lplam + this.p22 * lampp;
            double cl = Math.cos(lamtp);
            if (Math.abs(cl) < 1.0E-7) {
                lamtp -= 1.0E-7;
            }
            double fac = lampp - Math.sin(lampp) * (cl < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
            for (l = 50; l > 0; --l) {
                double d;
                lamt = lplam + this.p22 * sav;
                double c = Math.cos(lamt);
                if (Math.abs(d) < 1.0E-7) {
                    lamt -= 1.0E-7;
                }
                double xlam = (this.one_es * tanphi * this.sa + Math.sin(lamt) * this.ca) / c;
                lamdp = Math.atan(xlam) + fac;
                if (Math.abs(Math.abs(sav) - Math.abs(lamdp)) < 1.0E-7) break;
                sav = lamdp;
            }
            if (l == 0 || ++nn >= 3 || lamdp > this.rlm && lamdp < this.rlm2) break;
            if (lamdp <= this.rlm) {
                lampp = 7.853981633974483;
                continue;
            }
            if (!(lamdp >= this.rlm2)) continue;
            lampp = 1.5707963267948966;
        }
        if (l != 0) {
            double sp = Math.sin(lpphi);
            double phidp = ProjectionMath.asin((this.one_es * this.ca * sp - this.sa * Math.cos(lpphi) * Math.sin(lamt)) / Math.sqrt(1.0 - this.es * sp * sp));
            double tanph = Math.log(Math.tan(0.7853981633974483 + 0.5 * phidp));
            double sd = Math.sin(lamdp);
            double sdsq = sd * sd;
            double s2 = this.p22 * this.sa * Math.cos(lamdp) * Math.sqrt((1.0 + this.t * sdsq) / ((1.0 + this.w * sdsq) * (1.0 + this.q * sdsq)));
            double d = Math.sqrt(this.xj * this.xj + s2 * s2);
            xy.x = this.b * lamdp + this.a2 * Math.sin(2.0 * lamdp) + this.a4 * Math.sin(lamdp * 4.0) - tanph * s2 / d;
            xy.y = this.c1 * sd + this.c3 * Math.sin(lamdp * 3.0) + tanph * this.xj / d;
        } else {
            xy.y = Double.POSITIVE_INFINITY;
            xy.x = Double.POSITIVE_INFINITY;
        }
        return xy;
    }

    private void seraz0(double lam, double mult) {
        double sd = Math.sin(lam *= Math.PI / 180);
        double sdsq = sd * sd;
        double s2 = this.p22 * this.sa * Math.cos(lam) * Math.sqrt((1.0 + this.t * sdsq) / ((1.0 + this.w * sdsq) * (1.0 + this.q * sdsq)));
        double d__1 = 1.0 + this.q * sdsq;
        double h2 = Math.sqrt((1.0 + this.q * sdsq) / (1.0 + this.w * sdsq)) * ((1.0 + this.w * sdsq) / (d__1 * d__1) - this.p22 * this.ca);
        double sq = Math.sqrt(this.xj * this.xj + s2 * s2);
        double fc = mult * (h2 * this.xj - s2 * s2) / sq;
        this.b += fc;
        this.a2 += fc * Math.cos(lam + lam);
        this.a4 += fc * Math.cos(lam * 4.0);
        fc = mult * s2 * (h2 + this.xj) / sq;
        this.c1 += fc * Math.cos(lam);
        this.c3 += fc * Math.cos(lam * 3.0);
    }

    @Override
    public void initialize() {
        double lam;
        double alf;
        super.initialize();
        int land = 1;
        if (land <= 0 || land > 5) {
            throw new ProjectionException("-28");
        }
        int path = 120;
        if (path <= 0 || path > (land <= 3 ? 251 : 233)) {
            throw new ProjectionException("-29");
        }
        if (land <= 3) {
            this.projectionLongitude = 2.2492058070450924 - 0.025032610785576042 * (double)path;
            this.p22 = 103.2669323;
            alf = 1.729481662386221;
        } else {
            this.projectionLongitude = 2.2567107228286685 - 0.026966460545835135 * (double)path;
            this.p22 = 98.8841202;
            alf = 1.7139133254584316;
        }
        this.p22 /= 1440.0;
        this.sa = Math.sin(alf);
        this.ca = Math.cos(alf);
        if (Math.abs(this.ca) < 1.0E-9) {
            this.ca = 1.0E-9;
        }
        double esc = this.es * this.ca * this.ca;
        double ess = this.es * this.sa * this.sa;
        this.w = (1.0 - esc) * this.rone_es;
        this.w = this.w * this.w - 1.0;
        this.q = ess * this.rone_es;
        this.t = ess * (2.0 - this.es) * this.rone_es * this.rone_es;
        this.u = esc * this.rone_es;
        this.xj = this.one_es * this.one_es * this.one_es;
        this.rlm = 1.6341348883592068;
        this.rlm2 = this.rlm + Math.PI * 2;
        this.c3 = 0.0;
        this.c1 = 0.0;
        this.b = 0.0;
        this.a4 = 0.0;
        this.a2 = 0.0;
        this.seraz0(0.0, 1.0);
        for (lam = 9.0; lam <= 81.0001; lam += 18.0) {
            this.seraz0(lam, 4.0);
        }
        for (lam = 18.0; lam <= 72.0001; lam += 18.0) {
            this.seraz0(lam, 2.0);
        }
        this.seraz0(90.0, 1.0);
        this.a2 /= 30.0;
        this.a4 /= 60.0;
        this.b /= 30.0;
        this.c1 /= 15.0;
        this.c3 /= 45.0;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Landsat";
    }
}

