/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 82\u00020\u0001:\u00018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u00c6\u0003J)\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\u001c\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$2\b\u0010%\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$2\b\u0010'\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\nH\u0016J\u0012\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010.\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00069"}, d2={"Lorg/opensearch/commons/alerting/model/CronSchedule;", "Lorg/opensearch/commons/alerting/model/Schedule;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "expression", "", "timezone", "Ljava/time/ZoneId;", "testInstant", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/time/ZoneId;Ljava/time/Instant;)V", "executionTime", "Lcom/cronutils/model/time/ExecutionTime;", "getExecutionTime", "()Lcom/cronutils/model/time/ExecutionTime;", "getExpression", "()Ljava/lang/String;", "getTestInstant", "()Ljava/time/Instant;", "getTimezone", "()Ljava/time/ZoneId;", "asTemplateArg", "", "", "component1", "component2", "component3", "copy", "equals", "", "other", "getExpectedNextExecutionTime", "enabledTime", "expectedPreviousExecutionTime", "getPeriodEndingAt", "Lkotlin/Pair;", "endTime", "getPeriodStartingAt", "startTime", "hashCode", "", "nextTimeToExecute", "Ljava/time/Duration;", "runningOnTime", "lastExecutionTime", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class CronSchedule
extends Schedule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    @NotNull
    private final ZoneId timezone;
    @Nullable
    private final transient Instant testInstant;
    @NotNull
    private final transient ExecutionTime executionTime;

    public CronSchedule(@NotNull String expression, @NotNull ZoneId timezone, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(timezone, "timezone");
        super(null);
        this.expression = expression;
        this.timezone = timezone;
        this.testInstant = testInstant;
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)Schedule.Companion.getCronParser().parse(this.expression));
        Intrinsics.checkNotNullExpressionValue(executionTime, "forCron(...)");
        this.executionTime = executionTime;
    }

    public /* synthetic */ CronSchedule(String string, ZoneId zoneId, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            instant = null;
        }
        this(string, zoneId, instant);
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final ZoneId getTimezone() {
        return this.timezone;
    }

    @Nullable
    public final Instant getTestInstant() {
        return this.testInstant;
    }

    @NotNull
    public final ExecutionTime getExecutionTime() {
        return this.executionTime;
    }

    public CronSchedule(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter(sin, "sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        ZoneId zoneId = sin.readZoneId();
        Intrinsics.checkNotNullExpressionValue(zoneId, "readZoneId(...)");
        this(string, zoneId, null, 4, null);
    }

    @Override
    @Nullable
    public Duration nextTimeToExecute(@NotNull Instant enabledTime) {
        Intrinsics.checkNotNullParameter(enabledTime, "enabledTime");
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional timeToNextExecution = this.executionTime.timeToNextExecution(zonedDateTime);
        return timeToNextExecution.orElse(null);
    }

    @Override
    @Nullable
    public Instant getExpectedNextExecutionTime(@NotNull Instant enabledTime, @Nullable Instant expectedPreviousExecutionTime) {
        Intrinsics.checkNotNullParameter(enabledTime, "enabledTime");
        Instant instant = expectedPreviousExecutionTime;
        if (instant == null && (instant = this.testInstant) == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional nextExecution = this.executionTime.nextExecution(zonedDateTime);
        ZonedDateTime zonedDateTime2 = nextExecution.orElse(null);
        return zonedDateTime2 != null ? zonedDateTime2.toInstant() : null;
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant startTime) {
        Instant instant;
        if (startTime != null) {
            instant = startTime;
        } else {
            Optional lastExecutionTime = this.executionTime.lastExecution(ZonedDateTime.now(this.timezone));
            if (!lastExecutionTime.isPresent()) {
                Instant currentTime = Instant.now();
                return new Pair<Instant, Instant>(currentTime, currentTime);
            }
            instant = ((ZonedDateTime)lastExecutionTime.get()).toInstant();
        }
        Instant realStartTime = instant;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realStartTime, this.timezone);
        ZonedDateTime newEndTime = this.executionTime.nextExecution(zonedDateTime).orElse(null);
        Comparable<ChronoZonedDateTime<?>> comparable = newEndTime;
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = realStartTime;
        }
        return new Pair<Instant, ZonedDateTime>(realStartTime, (ZonedDateTime)comparable);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant endTime) {
        Instant instant;
        if (endTime != null) {
            instant = endTime;
        } else {
            Optional nextExecutionTime = this.executionTime.nextExecution(ZonedDateTime.now(this.timezone));
            if (!nextExecutionTime.isPresent()) {
                Instant currentTime = Instant.now();
                return new Pair<Instant, Instant>(currentTime, currentTime);
            }
            instant = ((ZonedDateTime)nextExecutionTime.get()).toInstant();
        }
        Instant realEndTime = instant;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realEndTime, this.timezone);
        ZonedDateTime newStartTime = this.executionTime.lastExecution(zonedDateTime).orElse(null);
        Comparable<ChronoZonedDateTime<?>> comparable = newStartTime;
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = realEndTime;
        }
        return new Pair<ZonedDateTime, Instant>((ZonedDateTime)comparable, realEndTime);
    }

    @Override
    public boolean runningOnTime(@Nullable Instant lastExecutionTime) {
        ZonedDateTime zonedDateTime;
        Optional expectedExecutionTime;
        if (lastExecutionTime == null) {
            return true;
        }
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        if (!(expectedExecutionTime = this.executionTime.lastExecution(zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone))).isPresent()) {
            return false;
        }
        ZonedDateTime actualExecutionTime = ZonedDateTime.ofInstant(lastExecutionTime, this.timezone);
        return ChronoUnit.SECONDS.between((Temporal)expectedExecutionTime.get(), actualExecutionTime) == 0L;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(params, "params");
        builder.startObject().startObject("cron").field("expression", this.expression).field("timezone", this.timezone.getId()).endObject().endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeString(this.expression);
        out.writeZoneId(this.timezone);
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("expression", this.expression), TuplesKt.to("timezone", this.timezone.toString())};
        return MapsKt.mapOf(TuplesKt.to("cron", MapsKt.mapOf(pairArray)));
    }

    @NotNull
    public final String component1() {
        return this.expression;
    }

    @NotNull
    public final ZoneId component2() {
        return this.timezone;
    }

    @Nullable
    public final Instant component3() {
        return this.testInstant;
    }

    @NotNull
    public final CronSchedule copy(@NotNull String expression, @NotNull ZoneId timezone, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(timezone, "timezone");
        return new CronSchedule(expression, timezone, testInstant);
    }

    public static /* synthetic */ CronSchedule copy$default(CronSchedule cronSchedule, String string, ZoneId zoneId, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            string = cronSchedule.expression;
        }
        if ((n & 2) != 0) {
            zoneId = cronSchedule.timezone;
        }
        if ((n & 4) != 0) {
            instant = cronSchedule.testInstant;
        }
        return cronSchedule.copy(string, zoneId, instant);
    }

    @NotNull
    public String toString() {
        return "CronSchedule(expression=" + this.expression + ", timezone=" + this.timezone + ", testInstant=" + this.testInstant + ")";
    }

    public int hashCode() {
        int result2 = this.expression.hashCode();
        result2 = result2 * 31 + this.timezone.hashCode();
        result2 = result2 * 31 + (this.testInstant == null ? 0 : this.testInstant.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CronSchedule)) {
            return false;
        }
        CronSchedule cronSchedule = (CronSchedule)other;
        if (!Intrinsics.areEqual(this.expression, cronSchedule.expression)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.timezone, cronSchedule.timezone)) {
            return false;
        }
        return Intrinsics.areEqual(this.testInstant, cronSchedule.testInstant);
    }

    @JvmStatic
    @NotNull
    public static final CronSchedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/commons/alerting/model/CronSchedule$Companion;", "", "()V", "readFrom", "Lorg/opensearch/commons/alerting/model/CronSchedule;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CronSchedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter(sin, "sin");
            return new CronSchedule(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

