/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.authuser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.opensearch.Version;
import org.opensearch.client.Response;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.internal.ToStringBuilder;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.Utils;
import org.opensearch.commons.authuser.util.Base64Helper;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public final class User
implements Writeable,
ToXContent {
    public static final String NAME_FIELD = "name";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ROLES_FIELD = "roles";
    public static final String CUSTOM_ATTRIBUTE_NAMES_FIELD = "custom_attribute_names";
    public static final String REQUESTED_TENANT_FIELD = "user_requested_tenant";
    public static final String REQUESTED_TENANT_ACCESS = "user_requested_tenant_access";
    private final String name;
    private final List<String> backendRoles;
    private final List<String> roles;
    private final Map<String, String> customAttributes;
    @Nullable
    private final String requestedTenant;
    @Nullable
    private final String requestedTenantAccess;

    public User() {
        this.name = "";
        this.backendRoles = new ArrayList<String>();
        this.roles = new ArrayList<String>();
        this.customAttributes = new HashMap<String, String>();
        this.requestedTenant = null;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, Map<String, String> customAttributes) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = customAttributes;
        this.requestedTenant = null;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, List<String> customAttNames) throws IllegalArgumentException {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = this.convertCustomAttributeNamesToMap(customAttNames);
        this.requestedTenant = null;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, Map<String, String> customAttributes, @Nullable String requestedTenant) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = customAttributes;
        this.requestedTenant = requestedTenant;
        this.requestedTenantAccess = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, Map<String, String> customAttributes, @Nullable String requestedTenant, @Nullable String requestedTenantAccess) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttributes = customAttributes;
        this.requestedTenant = requestedTenant;
        this.requestedTenantAccess = requestedTenantAccess;
    }

    public User(Response response) throws IOException, ParseException {
        this(EntityUtils.toString(response.getEntity()));
    }

    public User(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            throw new IllegalArgumentException("Response json cannot be null");
        }
        Map mapValue = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)json, (boolean)false);
        this.name = (String)mapValue.get("user_name");
        this.backendRoles = (List)mapValue.get(BACKEND_ROLES_FIELD);
        this.roles = (List)mapValue.get(ROLES_FIELD);
        Map<Object, Object> customAttributesFromJson = (Map<Object, Object>)mapValue.get("custom_attributes");
        List customAttNames = (List)mapValue.get(CUSTOM_ATTRIBUTE_NAMES_FIELD);
        this.customAttributes = customAttributesFromJson != null ? customAttributesFromJson : this.convertCustomAttributeNamesToMap(customAttNames);
        this.requestedTenant = mapValue.getOrDefault(REQUESTED_TENANT_FIELD, null);
        this.requestedTenantAccess = mapValue.getOrDefault(REQUESTED_TENANT_ACCESS, null);
    }

    public User(StreamInput in) throws IOException {
        this.name = in.readString();
        this.backendRoles = in.readStringList();
        this.roles = in.readStringList();
        List customAttNames = in.readStringList();
        this.customAttributes = this.convertCustomAttributeNamesToMap(customAttNames);
        this.requestedTenant = in.readOptionalString();
        this.requestedTenantAccess = in.getVersion().onOrAfter(Version.V_3_2_0) ? in.readOptionalString() : null;
    }

    public static User parse(XContentParser parser) throws IOException {
        String name = "";
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        String requestedTenant = null;
        String requestedTenantAccess = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    break;
                }
                case "roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        roles.add(parser.text());
                    }
                    break;
                }
                case "custom_attribute_names": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        Map<String, String> attributeInfo = User.parseAttributeInfoFromCustomAttributeName(parser.text());
                        customAttributes.put(attributeInfo.get("key"), attributeInfo.get("value"));
                    }
                    break;
                }
                case "user_requested_tenant": {
                    requestedTenant = parser.textOrNull();
                    break;
                }
                case "user_requested_tenant_access": {
                    requestedTenantAccess = parser.textOrNull();
                    break;
                }
            }
        }
        return new User(name, backendRoles, roles, customAttributes, requestedTenant, requestedTenantAccess);
    }

    public static User parse(String userString) {
        if (Strings.isNullOrEmpty((String)userString)) {
            return null;
        }
        String[] strs = userString.split("(?<!\\\\)\\|");
        if (strs.length == 0 || Strings.isNullOrEmpty((String)strs[0])) {
            return null;
        }
        String userName = Utils.unescapePipe(strs[0].trim());
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        String requestedTenant = null;
        String requestedTenantAccess = null;
        Map<String, String> customAttributes = new HashMap<String, String>();
        if (strs.length > 1 && !Strings.isNullOrEmpty((String)strs[1])) {
            backendRoles.addAll(Arrays.stream(strs[1].split(",")).map(Utils::unescapePipe).toList());
        }
        if (strs.length > 2 && !Strings.isNullOrEmpty((String)strs[2])) {
            roles.addAll(Arrays.stream(strs[2].split(",")).map(Utils::unescapePipe).toList());
        }
        if (strs.length > 3 && !Strings.isNullOrEmpty((String)strs[3])) {
            requestedTenant = Utils.unescapePipe(strs[3].trim());
        }
        if (strs.length > 4 && !Strings.isNullOrEmpty((String)strs[4])) {
            requestedTenantAccess = strs[4].trim();
        }
        if (strs.length > 5 && !Strings.isNullOrEmpty((String)strs[5])) {
            customAttributes = (Map)((Object)Base64Helper.deserializeObject(strs[5]));
        }
        return new User(userName, backendRoles, roles, customAttributes, requestedTenant, requestedTenantAccess);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(NAME_FIELD, this.name).field(BACKEND_ROLES_FIELD, this.backendRoles).field(ROLES_FIELD, this.roles).field(REQUESTED_TENANT_FIELD, this.requestedTenant).field(REQUESTED_TENANT_ACCESS, this.requestedTenantAccess);
        if (this.customAttributes.size() > 0) {
            builder.field(CUSTOM_ATTRIBUTE_NAMES_FIELD, this.getCustomAttributeNamesFromMap(this.customAttributes));
        } else {
            builder.field(CUSTOM_ATTRIBUTE_NAMES_FIELD, new ArrayList());
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.backendRoles);
        out.writeStringCollection(this.roles);
        out.writeStringCollection(this.getCustomAttributeNamesFromMap(this.customAttributes));
        out.writeOptionalString(this.requestedTenant);
        if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
            out.writeOptionalString(this.requestedTenantAccess);
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add(NAME_FIELD, (Object)this.name);
        builder.add(BACKEND_ROLES_FIELD, this.backendRoles);
        builder.add(ROLES_FIELD, this.roles);
        builder.add(CUSTOM_ATTRIBUTE_NAMES_FIELD, this.getCustomAttributeNamesFromMap(this.customAttributes));
        builder.add(REQUESTED_TENANT_FIELD, (Object)this.requestedTenant);
        builder.add(REQUESTED_TENANT_ACCESS, (Object)this.requestedTenantAccess);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return this.name.equals(that.name) && this.getBackendRoles().equals(that.backendRoles) && this.getRoles().equals(that.roles) && this.getCustomAttributes().equals(that.customAttributes) && Objects.equals(this.requestedTenant, that.requestedTenant) && Objects.equals(this.requestedTenantAccess, that.requestedTenantAccess);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public List<String> getCustomAttNames() {
        return this.getCustomAttributeNamesFromMap(this.customAttributes);
    }

    @Nullable
    public String getRequestedTenant() {
        return this.requestedTenant;
    }

    @Nullable
    public String getRequestedTenantAccess() {
        return this.requestedTenantAccess;
    }

    public boolean isAdminDn(Settings settings) {
        if (settings == null) {
            return false;
        }
        List adminDns = settings.getAsList("plugins.security.authcz.admin_dn", Collections.emptyList());
        return adminDns.contains(this.name);
    }

    private Map<String, String> convertCustomAttributeNamesToMap(List<String> customAttNames) {
        TreeMap<String, String> customAttributes = new TreeMap<String, String>();
        for (String entry : customAttNames) {
            Map<String, String> attributeInfo = User.parseAttributeInfoFromCustomAttributeName(entry);
            customAttributes.put(attributeInfo.get("key"), attributeInfo.get("value"));
        }
        return customAttributes;
    }

    private static Map<String, String> parseAttributeInfoFromCustomAttributeName(String customAttributeName) {
        int idx = customAttributeName.indexOf("=");
        if (idx == -1) {
            throw new IllegalArgumentException("No '=' present: " + customAttributeName);
        }
        String attrKey = customAttributeName.substring(0, idx);
        String attrValue = customAttributeName.substring(idx + 1);
        return Map.of("key", attrKey, "value", attrValue);
    }

    private List<String> getCustomAttributeNamesFromMap(Map<String, String> customAttributes) {
        ArrayList<String> customAttNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
            customAttNames.add(entry.getKey() + "=" + entry.getValue());
        }
        Collections.sort(customAttNames);
        return customAttNames;
    }
}

