/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.FunctionName;
import shaded.com.google.common.collect.ImmutableMap;

public class Cast
extends UnresolvedExpression {
    private static final Map<String, FunctionName> CONVERTED_TYPE_FUNCTION_NAME_MAP = new ImmutableMap.Builder<String, FunctionName>().put("string", BuiltinFunctionName.CAST_TO_STRING.getName()).put("byte", BuiltinFunctionName.CAST_TO_BYTE.getName()).put("short", BuiltinFunctionName.CAST_TO_SHORT.getName()).put("int", BuiltinFunctionName.CAST_TO_INT.getName()).put("integer", BuiltinFunctionName.CAST_TO_INT.getName()).put("long", BuiltinFunctionName.CAST_TO_LONG.getName()).put("float", BuiltinFunctionName.CAST_TO_FLOAT.getName()).put("double", BuiltinFunctionName.CAST_TO_DOUBLE.getName()).put("boolean", BuiltinFunctionName.CAST_TO_BOOLEAN.getName()).put("date", BuiltinFunctionName.CAST_TO_DATE.getName()).put("time", BuiltinFunctionName.CAST_TO_TIME.getName()).put("timestamp", BuiltinFunctionName.CAST_TO_TIMESTAMP.getName()).put("datetime", BuiltinFunctionName.CAST_TO_DATETIME.getName()).put("ip", BuiltinFunctionName.CAST_TO_IP.getName()).put("json", BuiltinFunctionName.CAST_TO_JSON.getName()).build();
    private final UnresolvedExpression expression;
    private final UnresolvedExpression convertedType;

    public static boolean isCastFunction(FunctionName name) {
        return CONVERTED_TYPE_FUNCTION_NAME_MAP.containsValue(name);
    }

    public DataType getDataType() {
        String type2 = this.convertedType.toString().toUpperCase(Locale.ROOT);
        if ("INT".equals(type2)) {
            type2 = "INTEGER";
        }
        if ("JSON".equals(type2)) {
            type2 = "STRING";
        }
        return DataType.valueOf(type2);
    }

    public static FunctionName getCastFunctionName(ExprType targetType) {
        String type2 = targetType.typeName().toLowerCase(Locale.ROOT);
        return CONVERTED_TYPE_FUNCTION_NAME_MAP.get(type2);
    }

    public FunctionName convertFunctionName() {
        String type2 = this.convertedType.toString().toLowerCase(Locale.ROOT);
        if (CONVERTED_TYPE_FUNCTION_NAME_MAP.containsKey(type2)) {
            return CONVERTED_TYPE_FUNCTION_NAME_MAP.get(type2);
        }
        throw new IllegalStateException("unsupported cast type: " + type2);
    }

    @Override
    public List<? extends Node> getChild() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitCast(this, context);
    }

    @Generated
    public Cast(UnresolvedExpression expression, UnresolvedExpression convertedType) {
        this.expression = expression;
        this.convertedType = convertedType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cast)) {
            return false;
        }
        Cast other = (Cast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnresolvedExpression this$expression = this.getExpression();
        UnresolvedExpression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression)) {
            return false;
        }
        UnresolvedExpression this$convertedType = this.getConvertedType();
        UnresolvedExpression other$convertedType = other.getConvertedType();
        return !(this$convertedType == null ? other$convertedType != null : !((Object)this$convertedType).equals(other$convertedType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cast;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        UnresolvedExpression $expression = this.getExpression();
        result2 = result2 * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
        UnresolvedExpression $convertedType = this.getConvertedType();
        result2 = result2 * 59 + ($convertedType == null ? 43 : ((Object)$convertedType).hashCode());
        return result2;
    }

    @Generated
    public UnresolvedExpression getExpression() {
        return this.expression;
    }

    @Generated
    public UnresolvedExpression getConvertedType() {
        return this.convertedType;
    }

    @Override
    @Generated
    public String toString() {
        return "Cast(expression=" + String.valueOf(this.getExpression()) + ", convertedType=" + String.valueOf(this.getConvertedType()) + ")";
    }
}

