/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import shaded.com.google.common.collect.ImmutableList;

public class Field
extends UnresolvedExpression {
    private final UnresolvedExpression field;
    private final List<Argument> fieldArgs;

    public Field(UnresolvedExpression field) {
        this(field, Collections.emptyList());
    }

    public Field(UnresolvedExpression field, List<Argument> fieldArgs) {
        this.field = field;
        this.fieldArgs = fieldArgs;
    }

    public boolean hasArgument() {
        return !this.fieldArgs.isEmpty();
    }

    public List<UnresolvedExpression> getChild() {
        return ImmutableList.of(this.field);
    }

    @Override
    public <R, C> R accept(AbstractNodeVisitor<R, C> nodeVisitor, C context) {
        return nodeVisitor.visitField(this, context);
    }

    @Generated
    public UnresolvedExpression getField() {
        return this.field;
    }

    @Generated
    public List<Argument> getFieldArgs() {
        return this.fieldArgs;
    }

    @Override
    @Generated
    public String toString() {
        return "Field(field=" + String.valueOf(this.getField()) + ", fieldArgs=" + String.valueOf(this.getFieldArgs()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnresolvedExpression this$field = this.getField();
        UnresolvedExpression other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        List<Argument> this$fieldArgs = this.getFieldArgs();
        List<Argument> other$fieldArgs = other.getFieldArgs();
        return !(this$fieldArgs == null ? other$fieldArgs != null : !((Object)this$fieldArgs).equals(other$fieldArgs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        UnresolvedExpression $field = this.getField();
        result2 = result2 * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        List<Argument> $fieldArgs = this.getFieldArgs();
        result2 = result2 * 59 + ($fieldArgs == null ? 43 : ((Object)$fieldArgs).hashCode());
        return result2;
    }
}

