/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import inet.ipaddr.IPAddress;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprIntervalValue;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprMissingValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public final class ExprValueUtils {
    public static final ExprValue LITERAL_TRUE = ExprBooleanValue.of(true);
    public static final ExprValue LITERAL_FALSE = ExprBooleanValue.of(false);
    public static final ExprValue LITERAL_NULL = ExprNullValue.of();
    public static final ExprValue LITERAL_MISSING = ExprMissingValue.of();

    public static ExprValue booleanValue(Boolean value) {
        return value != false ? LITERAL_TRUE : LITERAL_FALSE;
    }

    public static ExprValue byteValue(Byte value) {
        return new ExprByteValue(value);
    }

    public static ExprValue shortValue(Short value) {
        return new ExprShortValue(value);
    }

    public static ExprValue integerValue(Integer value) {
        return new ExprIntegerValue(value);
    }

    public static ExprValue doubleValue(Double value) {
        return new ExprDoubleValue(value);
    }

    public static ExprValue floatValue(Float value) {
        return new ExprFloatValue(value);
    }

    public static ExprValue longValue(Long value) {
        return new ExprLongValue(value);
    }

    public static ExprValue stringValue(String value) {
        return new ExprStringValue(value);
    }

    public static ExprValue intervalValue(TemporalAmount value) {
        return new ExprIntervalValue(value);
    }

    public static ExprValue dateValue(LocalDate value) {
        return new ExprDateValue(value);
    }

    public static ExprValue timeValue(LocalTime value) {
        return new ExprTimeValue(value);
    }

    public static ExprValue timestampValue(Instant value) {
        return new ExprTimestampValue(value);
    }

    public static ExprValue ipValue(String value) {
        return new ExprIpValue(value);
    }

    public static ExprValue tupleValue(Map<String, Object> map) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        map.forEach((k, v) -> valueMap.put((String)k, v instanceof ExprValue ? (ExprValue)v : ExprValueUtils.fromObjectValue(v)));
        return new ExprTupleValue(valueMap);
    }

    public static ExprValue collectionValue(List<Object> list) {
        ArrayList<ExprValue> valueList = new ArrayList<ExprValue>();
        list.forEach(o -> valueList.add(ExprValueUtils.fromObjectValue(o)));
        return new ExprCollectionValue(valueList);
    }

    public static ExprValue missingValue() {
        return ExprMissingValue.of();
    }

    public static ExprValue nullValue() {
        return ExprNullValue.of();
    }

    public static ExprValue fromObjectValue(Object o) {
        if (null == o) {
            return LITERAL_NULL;
        }
        if (o instanceof Map) {
            return ExprValueUtils.tupleValue((Map)o);
        }
        if (o instanceof List) {
            return ExprValueUtils.collectionValue((List)o);
        }
        if (o instanceof Byte) {
            return ExprValueUtils.byteValue((Byte)o);
        }
        if (o instanceof Short) {
            return ExprValueUtils.shortValue((Short)o);
        }
        if (o instanceof Integer) {
            return ExprValueUtils.integerValue((Integer)o);
        }
        if (o instanceof Long) {
            return ExprValueUtils.longValue((Long)o);
        }
        if (o instanceof Boolean) {
            return ExprValueUtils.booleanValue((Boolean)o);
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            if (Double.isNaN(d)) {
                return LITERAL_NULL;
            }
            return ExprValueUtils.doubleValue(d);
        }
        if (o instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)o;
            return new ExprDoubleValue(d);
        }
        if (o instanceof String) {
            return ExprValueUtils.stringValue((String)o);
        }
        if (o instanceof Float) {
            Float f = (Float)o;
            if (Float.isNaN(f.floatValue())) {
                return LITERAL_NULL;
            }
            return ExprValueUtils.floatValue(f);
        }
        if (o instanceof Date) {
            return ExprValueUtils.dateValue(((Date)o).toLocalDate());
        }
        if (o instanceof LocalDate) {
            return ExprValueUtils.dateValue((LocalDate)o);
        }
        if (o instanceof Time) {
            return ExprValueUtils.timeValue(((Time)o).toLocalTime());
        }
        if (o instanceof LocalTime) {
            return ExprValueUtils.timeValue((LocalTime)o);
        }
        if (o instanceof Instant) {
            return ExprValueUtils.timestampValue((Instant)o);
        }
        if (o instanceof Timestamp) {
            return ExprValueUtils.timestampValue(((Timestamp)o).toInstant());
        }
        if (o instanceof LocalDateTime) {
            return ExprValueUtils.timestampValue(((LocalDateTime)o).toInstant(ZoneOffset.UTC));
        }
        if (o instanceof TemporalAmount) {
            return ExprValueUtils.intervalValue((TemporalAmount)o);
        }
        throw new ExpressionEvaluationException("unsupported object " + String.valueOf(o.getClass()));
    }

    /*
     * Exception decompiling
     */
    public static ExprValue fromObjectValue(Object o, ExprType type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=4,369
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Byte getByteValue(ExprValue exprValue) {
        return exprValue.byteValue();
    }

    public static Short getShortValue(ExprValue exprValue) {
        return exprValue.shortValue();
    }

    public static Integer getIntegerValue(ExprValue exprValue) {
        return exprValue.integerValue();
    }

    public static Double getDoubleValue(ExprValue exprValue) {
        return exprValue.doubleValue();
    }

    public static Long getLongValue(ExprValue exprValue) {
        return exprValue.longValue();
    }

    public static Float getFloatValue(ExprValue exprValue) {
        return exprValue.floatValue();
    }

    public static String getStringValue(ExprValue exprValue) {
        return exprValue.stringValue();
    }

    public static List<ExprValue> getCollectionValue(ExprValue exprValue) {
        return exprValue.collectionValue();
    }

    public static Map<String, ExprValue> getTupleValue(ExprValue exprValue) {
        return exprValue.tupleValue();
    }

    public static IPAddress getIpValue(ExprValue exprValue) {
        return exprValue.ipValue();
    }

    public static Boolean getBooleanValue(ExprValue exprValue) {
        return exprValue.booleanValue();
    }

    public static ExprValue resolveRefPaths(ExprValue value, List<String> paths) {
        ExprValue wholePathValue = value.keyValue(String.join((CharSequence)".", paths));
        if (value.type().equals(ExprCoreType.ARRAY)) {
            wholePathValue = value.collectionValue().getFirst().keyValue(paths.getFirst());
        }
        if (!wholePathValue.isMissing() || paths.size() == 1) {
            return wholePathValue;
        }
        return ExprValueUtils.resolveRefPaths(value.keyValue(paths.getFirst()), paths.subList(1, paths.size()));
    }

    @Generated
    private ExprValueUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

