/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionImplementation;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public abstract class Aggregator<S extends AggregationState>
implements FunctionImplementation,
Expression {
    private final FunctionName functionName;
    private final List<Expression> arguments;
    protected final ExprCoreType returnType;
    protected Expression condition;
    protected Boolean distinct = false;

    public abstract S create();

    protected abstract S iterate(ExprValue var1, S var2);

    public S iterate(BindingTuple tuple, S state) {
        ExprValue value = this.getArguments().get(0).valueOf(tuple);
        if (value.isNull() || value.isMissing() || !this.conditionValue(tuple)) {
            return state;
        }
        return this.iterate(value, state);
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        throw new ExpressionEvaluationException(String.format("can't evaluate on aggregator: %s", this.functionName));
    }

    @Override
    public ExprType type() {
        return this.returnType;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor2, C context) {
        return visitor2.visitAggregator(this, context);
    }

    public boolean conditionValue(BindingTuple tuple) {
        if (this.condition == null) {
            return true;
        }
        return ExprValueUtils.getBooleanValue(this.condition.valueOf(tuple));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Aggregator)) {
            return false;
        }
        Aggregator other = (Aggregator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$distinct = this.distinct();
        Boolean other$distinct = other.distinct();
        if (this$distinct == null ? other$distinct != null : !((Object)this$distinct).equals(other$distinct)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        List<Expression> this$arguments = this.getArguments();
        List<Expression> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        ExprCoreType this$returnType = this.returnType;
        ExprCoreType other$returnType = other.returnType;
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        Expression this$condition = this.condition();
        Expression other$condition = other.condition();
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Aggregator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Boolean $distinct = this.distinct();
        result2 = result2 * 59 + ($distinct == null ? 43 : ((Object)$distinct).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result2 = result2 * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        List<Expression> $arguments = this.getArguments();
        result2 = result2 * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        ExprCoreType $returnType = this.returnType;
        result2 = result2 * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        Expression $condition = this.condition();
        result2 = result2 * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result2;
    }

    @Generated
    public Aggregator(FunctionName functionName, List<Expression> arguments2, ExprCoreType returnType) {
        this.functionName = functionName;
        this.arguments = arguments2;
        this.returnType = returnType;
    }

    @Override
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Override
    @Generated
    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Generated
    public Aggregator<S> condition(Expression condition) {
        this.condition = condition;
        return this;
    }

    @Generated
    public Expression condition() {
        return this.condition;
    }

    @Generated
    public Aggregator<S> distinct(Boolean distinct2) {
        this.distinct = distinct2;
        return this;
    }

    @Generated
    public Boolean distinct() {
        return this.distinct;
    }
}

