/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.jsonUDF;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;

public class JsonUtils {
    static ObjectMapper objectMapper = new ObjectMapper();
    public static Gson gson = new Gson();
    public static String MEANING_LESS_KEY_FOR_APPEND_AND_EXTEND = ".meaningless_key";

    public static String convertToJsonPath(String input) {
        if (input == null || input.isEmpty()) {
            return "$";
        }
        StringBuilder sb = new StringBuilder("$.");
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '{') {
                int end = input.indexOf(125, i);
                if (end == -1) {
                    throw new IllegalArgumentException("Unmatched { in input when converting json path");
                }
                String index = input.substring(i + 1, end).trim();
                if (index.isEmpty()) {
                    sb.append("[*]");
                } else {
                    sb.append("[").append(index).append("]");
                }
                i = end + 1;
                continue;
            }
            if (c == '.') {
                sb.append(".");
                ++i;
                continue;
            }
            int start = i;
            while (i < input.length() && input.charAt(i) != '.' && input.charAt(i) != '{') {
                ++i;
            }
            sb.append(input, start, i);
        }
        return sb.toString();
    }

    public static JsonNode convertInputToJsonNode(Object input) {
        try {
            Object root = input instanceof String ? objectMapper.readTree(input.toString()) : objectMapper.valueToTree(input);
            return root;
        }
        catch (Exception e) {
            throw new RuntimeException("fail to parse input", e);
        }
    }

    public static List<String> expandJsonPath(JsonNode root, String rawPath) {
        String cleanedPath = rawPath.replaceFirst("^\\$\\.", "").replaceFirst("^\\$", "");
        String[] parts = cleanedPath.split("\\.");
        return JsonUtils.expand(root, parts, 0, "$");
    }

    private static List<String> expand(JsonNode currentNode, String[] parts, int index, String prefix) {
        if (index >= parts.length || currentNode == null) {
            return List.of(prefix);
        }
        String part = parts[index];
        ArrayList<String> results = new ArrayList<String>();
        if (part.endsWith("[*]")) {
            String field = part.substring(0, part.length() - 3);
            JsonNode arrayNode = field.isEmpty() ? currentNode : currentNode.get(field);
            if (arrayNode != null && arrayNode.isArray()) {
                for (int i = 0; i < arrayNode.size(); ++i) {
                    String newPrefix = prefix + "." + field + "[" + i + "]";
                    results.addAll(JsonUtils.expand(arrayNode.get(i), parts, index + 1, newPrefix));
                }
            }
        } else if (part.endsWith("]")) {
            String newPrefix;
            int leftBracketIndex = part.lastIndexOf(91);
            String field = part.substring(0, part.length() - 3);
            JsonNode arrayNode = field.isEmpty() ? currentNode : currentNode.get(field);
            Boolean arrayFlag = false;
            if (leftBracketIndex > -1 && part.substring(leftBracketIndex + 1, part.length() - 1).matches("-?\\d+")) {
                int currentIndex = Integer.parseInt(part.substring(leftBracketIndex + 1, part.length() - 1));
                if (arrayNode != null && arrayNode.isArray() && arrayNode.size() > currentIndex) {
                    newPrefix = prefix + "." + part;
                    results.addAll(JsonUtils.expand(arrayNode.get(currentIndex), parts, index + 1, newPrefix));
                    arrayFlag = true;
                }
            }
            if (!arrayFlag.booleanValue()) {
                JsonNode next = currentNode.get(part);
                newPrefix = prefix + "." + part;
                results.addAll(JsonUtils.expand(next, parts, index + 1, newPrefix));
            }
        } else {
            JsonNode next = currentNode.get(part);
            String newPrefix = prefix + "." + part;
            results.addAll(JsonUtils.expand(next, parts, index + 1, newPrefix));
        }
        return results;
    }
}

