/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.parse;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.common.grok.Grok;
import org.opensearch.sql.common.grok.GrokCompiler;
import org.opensearch.sql.common.grok.Match;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.parse.ParseExpression;

public class GrokExpression
extends ParseExpression {
    private static final Logger log = LogManager.getLogger(GrokExpression.class);
    private static final GrokCompiler grokCompiler = GrokCompiler.newInstance();
    private final Grok grok;

    public GrokExpression(Expression sourceField, Expression pattern, Expression identifier) {
        super("grok", sourceField, pattern, identifier);
        this.grok = grokCompiler.compile(pattern.valueOf().stringValue());
    }

    @Override
    public ExprValue parseValue(ExprValue value) throws ExpressionEvaluationException {
        String rawString = value.stringValue();
        Match grokMatch = this.grok.match(rawString);
        Map<String, Object> capture = grokMatch.capture();
        Object match = capture.get(this.identifierStr);
        if (match != null) {
            return new ExprStringValue(match.toString());
        }
        log.debug("failed to extract pattern {} from input ***", (Object)this.grok.getOriginalGrokPattern());
        return new ExprStringValue("");
    }

    public static List<String> getNamedGroupCandidates(String pattern) {
        Grok grok = grokCompiler.compile(pattern);
        return grok.namedGroups.stream().map(grok::getNamedRegexCollectionById).filter(group -> !group.equals("UNWANTED")).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrokExpression)) {
            return false;
        }
        GrokExpression other = (GrokExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrokExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int result2 = super.hashCode();
        return result2;
    }

    @Override
    @Generated
    public String toString() {
        return "GrokExpression(grok=" + String.valueOf(this.grok) + ")";
    }

    static {
        grokCompiler.registerDefaultPatterns();
    }
}

